<?php

namespace App\Helpers;

class Constant
{
    const CATEGORY_STATUS = [
        'Active'     => 1,
        'Not active' => 2,
    ];

    const CATEGORY_APP_HOME = [
        'False' => 0,
        'True'  => 1,
    ];

    const COUNTRY_STATUS = [
        'Active'     => 1,
        'Not active' => 2,
    ];

    const PACKAGE_STATUS = [
        'Active'     => 1,
        'Not active' => 2,
    ];

    const USER_TYPE = [
        'User'  => 1,
        'Store' => 2
    ];

    const USER_PLATFORM = [
        'Android' => 1,
        'Ios'     => 2,
        'Web'     => 3,
    ];

    const SOCIAL_MEDIA_TYPE = [
        'Facebook'  => 1,
        'Google'    => 2,
        'Twitter'   => 3,
        'Apple'     => 4,
    ];

    const USER_STATUS = [
        'Verified'      => 1,
        'Suspended'     => 2,
        'Not verified'  => 3,
    ];

    const STORE_REGISTRATION_STEP = [
        'First'     => 1,
        'Second'    => 2,
        'Third'     => 2,
    ];

    const STORE_COMPLETE_REGISTRATION = [
        'Completed'     => 1,
        'Not completed' => 2,
    ];

    const VERIFICATION_OBJECTIVE = [
        'Verify' => 1,
        'Reset'  => 2
    ];

    const VERIFICATION_INFORMATION_TYPE = [
        'Email' => 1,
        'Phone' => 2
    ];

    const VERIFICATION_USED = [
        'Used'      => 1,
        'Not used'  => 2,
    ];

    const PREMIUM_STATUS = [
        'True'  => 1,
        'False' => 2,
    ];

    const NEGOTIABLE_STATUS = [
        'False' => 0,
        'True'  => 1,
    ];

    const ADVERTISEMENT_USER_TYPE = [
        'Favorite'  => 1,
        'View'      => 2,
        'Share'     => 3,
        'Report'    => 4,
        'Search'    => 5,
    ];

    const SETTING_CONTENT_TYPE = [
        'String'    => 1,
        'Number'    => 2,
        'Time'      => 3,
    ];

    const CONTACT_US_TYPE = [
        'Contact'    => 1,
        'Newsletter'    => 2,
    ];

    const SETTING_KEYS = [
        'Welcome'                   => 1,
        'Contact us'                => 2,
        'Social media'              => 3,
        'About us'                  => 4,
        'Terms conditions'          => 5,
        'Advertisement Reports'     => 6,
        'Store Reports'             => 7,
        'Store Blocks'              => 8,
        'Logo'                      => 9,
        'Suggested ads'             => 10,
        'Most popular ads'          => 11,
        'Security tips'             => 12,
        'App info'                  => 13,
        'Email'                     => 14,
        'Phone'                     => 15,
        'Address'                   => 16,
        'Help'                      => 17,
        'How to use site'           => 18,
        'About sections'            => 19,
        'Team'                      => 20,
        'Meta'                => 21,
    ];
    const EXPLORE_USER_TYPE = [
        'Like'      => 1,
        'Share'     => 2,
        'Comment'     => 3,
    ];

    const USER_STORE_TYPE = [
        'Report'    => 1,
        'Block'     => 2,
        'View'      => 3,
        'Search'    => 4,
    ];

    const PROPERTY_TYPE = [
        'Radio'     => 1,
        'Switch'    => 2,
        'Text'      => 3,
        'Checkbox'  => 4,
    ];

    const MOST_POPULAR_ADS = [
        'Suggested ads'     => 1,
        'Most popular ads'  => 2,
    ];

    const FILTER_ORDER_BY = [
        'Newest'            => 1,
        'Oldest'            => 2,
        'Least price'       => 3,
        'Highest price'     => 4,
    ];

    const FILTER_ADVERTISEMENT_TYPE = [
        'All'       => 1,
        'Premium'   => 2,
        'Free'      => 3,
    ];

    const PACKAGE_HAS_PREMIUM_ADS = [
        'False' => 0,
        'True'  => 1,
    ];

    const NOTIFICATION_TYPE = [
        'Admin'         => 1,
        'Store'         => 2,
        'All'           => 3,
        'Advertisement' => 4,
    ];

    const USER_IMAGE_FOLDER_NAME = 'users';

    const STORE_IMAGE_FOLDER_NAME = 'stores';

    const CATEGORY_IMAGE_FOLDER_NAME = 'categories';

    const PROPERTY_IMAGE_FOLDER_NAME = 'properties';

    const COUNTRY_IMAGE_FOLDER_NAME = 'countries';

    const ADVERTISEMENT_IMAGE_FOLDER_NAME = 'advertisements';

    const EXPLORE_FOLDER_NAME = 'explores';

    const STORY_FOLDER_NAME = 'stories';

    const SLIDER_FOLDER_NAME = 'sliders';

    const SETTING_FOLDER_NAME = 'settings';

    const NOTIFICATION_IMAGE_FOLDER_NAME = 'notifications';

    public static function getPropertyTypeText($status)
    {
        switch ($status) {
            case self::PROPERTY_TYPE['Radio']:
                return __('Single select');
            case self::PROPERTY_TYPE['Checkbox']:
                return __('Multi select');
            case self::PROPERTY_TYPE['Switch']:
                return __('Switch');
            case self::PROPERTY_TYPE['Text']:
                return __('Text');
        }
    }
}
