<?php

namespace App\Http\Controllers\Api\Ajax\Country;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Ajax\GetCitiesRequest;
use App\Models\Country;

class CityController extends Controller
{
    public function cities(GetCitiesRequest $request)
    {
        $cities = Country::where('parent_id', $request->country_id)->with('translation')->get();

        return response()->json($cities);
    }
}
