<?php

namespace App\Http\Controllers\Api\V100\Advertisement;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Advertisement\GetAdvertisementsRequest;
use App\Http\Requests\Api\V100\Advertisement\GetAdvertisementDetailsRequest;
use App\Http\Resources\Advertisement\AdvertisementDetailsResource;
use App\Http\Resources\Advertisement\AdvertisementResource;
use App\Http\Resources\Advertisement\ReviewResource;
use App\Models\Advertisement;
use App\Services\Advertisement\AdvertisementService;
use App\Services\RespondActive;
use Illuminate\Support\Facades\DB;

class AdvertisementController extends Controller
{
    public function index(GetAdvertisementsRequest $request)
    {
        $advertisements = AdvertisementResource::collection(
            AdvertisementService::advertisementsBasedOnParameters([
                'sub_category_id'   => $request->sub_category_id,
                'limit'     => 20
            ])
        );

        return RespondActive::success('The action ran successfully!', $advertisements);
    }

    public function show(GetAdvertisementDetailsRequest $request, Advertisement $advertisement)
    {
        $advertisement = new AdvertisementDetailsResource(
            $advertisement->load('properties.translation', 'properties.parent', 'user', 'reviews')
        );

        if (auth('sanctum')->user() &&
            !auth('sanctum')->user()->advertisementsActionsByType($request->type)->exists($advertisement->id)) {

            auth('sanctum')->user()->advertisementsActions()->attach($advertisement->id, ['type'  => $request->type]);

            $advertisement->update(['views_count' => DB::raw('views_count + 1')]);
        }

        return RespondActive::success('The action ran successfully!', $advertisement);
    }

    public function reviews(Advertisement $advertisement)
    {
        $reviews = ReviewResource::collection($advertisement->reviews()->paginate())->response()->getData();

        return RespondActive::success('The action ran successfully!', $reviews);
    }
}
