<?php

namespace App\Http\Controllers\Api\V100\Advertisement;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Advertisement\UserAdvertisementAction\Favorite\SetFavoriteRequest;
use App\Http\Requests\Api\V100\Advertisement\UserAdvertisementAction\Report\SetReportRequest;
use App\Models\Advertisement;
use App\Services\RespondActive;

class UserAdvertisementAction extends Controller
{
    public function favorite(SetFavoriteRequest $request)
    {
        if (auth()->user()->advertisementsActions()->exists($request->advertisement_id)) {

            auth()->user()->advertisementsActions()->detach($request->advertisement_id);

            return RespondActive::success('Removed from favorites');
        }

        auth()->user()->advertisementsActions()->attach($request->advertisement_id, [
            'type' => Constant::ADVERTISEMENT_USER_TYPE['Favorite']
        ]);

        Advertisement::find($request->advertisement_id)->increment('favorite_count');

        return RespondActive::success('Added to favorites');
    }

    public function share(SetFavoriteRequest $request)
    {
        auth()->user()->advertisementsActions()->attach($request->advertisement_id, [
            'type' => Constant::ADVERTISEMENT_USER_TYPE['Share']
        ]);

        Advertisement::find($request->advertisement_id)->increment('share_count');

        return RespondActive::success('Shared successfully');
    }

    public function report(SetReportRequest $request)
    {
        auth()->user()->advertisementsActions()->attach($request->advertisement_id, [
            'type'      => Constant::ADVERTISEMENT_USER_TYPE['Report'],
            'reason_id' => $request->reason_id
        ]);

        return RespondActive::success('Report sent successfully');
    }
}
