<?php

namespace App\Http\Controllers\Api\V100\Explore;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Explore\SetExploreUserRequest;
use App\Http\Resources\Explore\ExploreCommentsResource;
use App\Http\Resources\Explore\ExploreResource;
use App\Models\Explore;
use App\Services\RespondActive;

class ExploreController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:sanctum')->only('store');
    }

    public function index()
    {
        $data = ExploreResource::collection(
            Explore::with('hubFiles', 'store')
                ->withCount('likes', 'comments', 'shares')
                ->inRandomOrder()
                ->paginate()
        )->response()->getData();

        return RespondActive::success('The action ran successfully!', $data);
    }

    public function store(SetExploreUserRequest $request)
    {
        $explore = Explore::find($request->explore_id);

        if ($request->type == Constant::EXPLORE_USER_TYPE['Like'] && $explore->users()->exists(auth()->id())) {

            $explore->users()->detach(auth()->id());
        } else {
            $explore->users()->attach(auth()->id(), [
                'type'      => $request->type,
                'comment'   => $request->comment,
            ]);
        }

        return RespondActive::success('The action ran successfully!');
    }

    public function show(Explore $explore)
    {
        $comments = ExploreCommentsResource::collection($explore->comments);

        return RespondActive::success('The action ran successfully!', $comments);
    }
}
