<?php

namespace App\Http\Controllers\Api\V100;

use App\Http\Controllers\Controller;
use App\Http\Resources\Country\CountryResource;
use App\Models\Country;
use App\Services\RespondActive;

class GetCountries extends Controller
{
    public function __invoke()
    {
        $countries = CountryResource::collection(
            Country::with('cities.translation','translation')->getActiveCountries()->get()
        );

        return RespondActive::success('The action ran successfully!', $countries);
    }
}
