<?php

namespace App\Http\Controllers\Api\V100;

use App\Http\Controllers\Controller;
use App\Http\Resources\User\NotificationResource;
use App\Models\Notification;
use App\Services\RespondActive;

class NotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return
     */
    public function index()
    {
        $notifications =
        NotificationResource::collection(
            auth()->user()->notifications()->orWhere('all_users', 1)->paginate()
        )
        ->response()
        ->getData();

        auth()->user()->notifications()->update([ 'seen' => 1 ]);

        return RespondActive::success('The action ran successfully!', $notifications);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  Notification  $notification
     * @return
     */
    public function destroy(Notification $notification)
    {
        $notification->delete();

        return RespondActive::success('The action ran successfully!');
    }
}
