<?php

namespace App\Http\Controllers\Api\V100\Settings;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Setting\GetSettingRequest;
use App\Http\Requests\Api\V100\Setting\SetContactUsRequest;
use App\Http\Resources\Setting\SettingResource;
use App\Models\ContactUs;
use App\Services\RespondActive;

class SetContactUs extends Controller
{
    public function __invoke(SetContactUsRequest $request)
    {
        ContactUs::create($request->validated() + ['user_id' => auth('sanctum')->id()]);

        return RespondActive::success('The action ran successfully!');
    }
}
