<?php

namespace App\Http\Controllers\Api\V100\Store;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Store\SetStoreReportRequest;
use App\Http\Resources\User\StoreResource;
use App\Models\User;
use App\Services\RespondActive;
use App\Services\User\StoreService;

class StoreController extends Controller
{
    public function index()
    {
        $stores = StoreResource::collection(
            StoreService::storesBasedOnParameters([
                'paginate'  => true,
                'limit'     => 15
            ])
        )->response()->getData();

        return RespondActive::success('The action ran successfully!', $stores);
    }

    public function show(User $store)
    {
        $store->load('advertisements.user', 'city');

        return RespondActive::success('The action ran successfully!', new StoreResource($store));
    }

    public function report(SetStoreReportRequest $request)
    {
        auth()->user()->reports()->attach($request->store_id, [
            'type'      => Constant::USER_STORE_TYPE['Report'],
            'reason_id' => $request->reason_id
        ]);

        return RespondActive::success('Report sent successfully');
    }

    public function block(SetStoreReportRequest $request)
    {
        auth()->user()->reports()->attach($request->store_id, [
            'type'      => Constant::USER_STORE_TYPE['Report'],
            'reason_id' => $request->reason_id
        ]);

        return RespondActive::success('Block sent successfully');
    }
}
