<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Website\V100\AddCommentRequest;
use App\Http\Requests\Website\V100\FavoriteRequest;
use App\Http\Requests\Website\V100\FollowRequest;
use App\Http\Requests\Website\V100\SetAdvertisementReportRequest;
use App\Http\Requests\Website\V100\SetExploreUserCommentRequest;
use App\Http\Requests\Website\V100\SetExploreUserRequest;
use App\Http\Requests\Website\V100\SetStoreReportRequest;
use App\Models\Advertisement;
use App\Models\Country;
use App\Models\Explore;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;

class ActionsController extends Controller
{
    public function follow(FollowRequest $request,$lang){
        if( auth()->user()->followings()->where('store_id',$request->shop_id)->first()) {

            auth()->user()->followings()->detach($request->shop_id);
            $notification=array(
                'message'=>__('website.unfollowed-successfully'),
                'type'=>'success',
                'followType'=>'unfollow',
            );

        }else {

            auth()->user()->followings()->attach($request->shop_id);
            $notification=array(
                'message'=>__('website.followed-successfully'),
                'type'=>'success',
                'followType'=>'follow',

            );

        }

        return $notification;


    }
    public function favorite(FavoriteRequest $request)
    {
//        dd(auth()->user()->advertisementsActionsByType(Constant::ADVERTISEMENT_USER_TYPE['Favorite'])
//            ->where('advertisement_id', $request->advertisement_id)->exists());
//       dd(auth()->user()->advertisementsActionsByType(Constant::ADVERTISEMENT_USER_TYPE['Favorite'])
//           ->where('advertisement_id', $request->advertisement_id)->exists());
        if (auth()->user()->advertisementsActionsByType(Constant::ADVERTISEMENT_USER_TYPE['Favorite'])
            ->where('advertisement_id', $request->advertisement_id)->exists()) {

          auth()->user()->advertisementsActionsByType(Constant::ADVERTISEMENT_USER_TYPE['Favorite'])
                ->detach($request->advertisement_id);

           Advertisement::find($request->advertisement_id)->decrement('favorite_count');
            return array(
                'message'=>__('website.removed-from-favorites'),
                'type'=>'success',
                'favoriteType'=>'unfavorite',

            );



        }

        auth()->user()->advertisementsActions()->attach($request->advertisement_id, [
            'type' => Constant::ADVERTISEMENT_USER_TYPE['Favorite']
        ]);


        Advertisement::find($request->advertisement_id)->increment('favorite_count');
        return array(
            'message'=>__('website.added-to-favorites'),
            'type'=>'success',
            'favoriteType'=>'favorite',

        );
    }
    public function changeCountry(Request $request){
        $country=Country::whereId($request->country)->first();
        Session::forget(['country','country_name']);
        Session::put('country',$request->country);
        Session::put('country_name',$request->country_name);
        Session::put('currency',$country->currency);
        Session::save();
    }
    public function changeLanguage(Request $request){

        return redirect()->back();
    }

//    public function changeCurrency(Request $request){
//        Session::forget('currency');
//        Session::put('currency',$request->currency);
//
//    }
    public function addComment(AddCommentRequest $request){
//        return $request->rate;
        if ($request->store_id) {
            $model = User::find($request->store_id, ['id', 'average_rate', 'rate_count']);
        }else {
            $model = Advertisement::find($request->advertisement_id, ['id', 'average_rate', 'rate_count']);
        }

         $model->reviews()->create([
            'user_id'   => auth()->id(),
            'rate'      => $request->rate,
            'review'    => $request->review,
        ]);

        $model->update([
            'average_rate' => $model->reviews->avg('rate'),
        ]);

        $model->increment('rate_count');
        $notification=array(
            'message'=>__('website.comment-added-successfully'),
            'type'=>'success',
        );

        return redirect()->back()->with($notification);


    }

    public function reportBlock(SetStoreReportRequest $request)
    {
        auth()->user()->storesByType($request->type)->attach($request->store_id, [
            'type'      => $request->type,
            'reason_id' => $request->reason_id
        ]);
        $notification=array(
            'message'=>__('website.added-successfully'),
            'type'=>'success',
        );

        return redirect()->back()->with($notification);
    }
    public function unBlock(FollowRequest $request,$lang)
    {
        auth()->user()->storesByType(Constant::USER_STORE_TYPE['Block'])->detach($request->shop_id);
        $notification=array(
            'message'=>__('website.unblocked-successfully'),
            'type'=>'success',
        );

        return redirect()->back()->with($notification);
    }
    public function reportAdvertisement(SetAdvertisementReportRequest $request)
    {
        auth()->user()->advertisementsActions()->attach($request->advertisement_id, [
            'type'      => Constant::ADVERTISEMENT_USER_TYPE['Report'],
            'reason_id' => $request->reason_id
        ]);
        $notification=array(
            'message'=>__('website.reported-successfully'),
            'type'=>'success',
        );

        return redirect()->back()->with($notification);
    }
    public function favoriteExplore(SetExploreUserRequest $request)
    {
        $explore = Explore::find($request->explore_id);

        if ($explore->users()->where(['user_id' => auth()->id(), 'type' => $request->type])->exists() && $request->type == Constant::EXPLORE_USER_TYPE['Like']) {

            $explore->users()->where(['user_id' => auth()->id(), 'type' => $request->type])->detach(auth()->id());
            return array(
                'message'=>__('website.removed-from-favorites'),
                'type'=>'success',
                'favoriteType'=>'unfavorite',

            );

        } else {
            $explore->users()->attach(auth()->id(), ['type' => $request->type]);
            return array(
                'message'=>__('website.added-to-favorites'),
                'type'=>'success',
                'favoriteType'=>'favorite',

            );

        }


    }
    public function storeExploreComment($lang,SetExploreUserCommentRequest $request ,$explore_id)
    {
         Explore::find($explore_id)->comments()->create([
            'comment'   => $request->comment,
            'user_id'   => auth()->id()
        ]);


        $notification= array(
            'message'=>__('website.comment-added-successfully'),
            'type'=>'success',
        );
        return redirect()->back()->with($notification);

    }

}
