<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Requests\Api\V100\Auth\VerifyUserConfirmationCodeRequest;
use App\Http\Requests\Website\V100\UpdateUserProfileRequest;
use App\Http\Requests\Website\V100\AuthRequest;
use App\Http\Requests\Website\V100\VerifyCodeRequest;
use App\Http\Resources\User\UserResource;
use App\Models\Advertisement;
use App\Models\Country;
use App\Models\User;
use App\Models\VerificationCode;
use App\Services\Advertisement\AdvertisementService;
use App\Services\Auth\VerificationService;
use App\Services\RespondActive;
use App\Services\Website\CountryService;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;

class AuthController extends Controller
{
    public function login()
    {
        return view('Website.auth.login');
    }

    public function redirectToProvider($provider)
    {
        return Socialite::driver('facebook')->redirect();


    }

    public function handleProviderCallback(Request $request, $provider)
    {
        $user = Socialite::driver($provider)->user();

        $auth_user = $this->findOrCreateUser($user, $provider);
        dd($auth_user);
        Auth::login($auth_user, true);
    }

    /**
     * get or create user.
     *
     * @return Response
     */
    public function findOrCreateUser($user, $provider)
    {
        $authUser = User::where('email', $user->email)->first();

        if ($authUser) {
            return $authUser;
        }

        $name = explode(' ', $user->name);

        return User::create([
            'first_name' => $name[0],
            'last_name' => isset($name[1]) ? $name[1] : '',
            'email' => $user->email,
            'provider' => $provider,
            'provider_id' => $user->id,
            'avatar' => $user->avatar
        ]);
    }

    public function submitLogin(AuthRequest $request)
    {
        $user = User::checkUserExist($request->phone)->first();

        if (!$user) {
            $user = User::create($request->validated() + [
                    'account_type' => Constant::USER_TYPE['User'],
                ]);
        }

        if (auth('sanctum')->user()) {
            $user = auth('sanctum')->user();

            $user->update($request->validated());
        }

        $user->update(['verified' => Constant::USER_STATUS['Not verified']]);
//        $selectedCountry=CountryService::selectCountry();
        try {

            VerificationService::verifyAccount(
                $user->id,
                Constant::VERIFICATION_OBJECTIVE['Verify'],
                Constant::VERIFICATION_INFORMATION_TYPE['Phone'],
                $request->phone,
                $request->country_code

            );
        } catch (Exception $exception) {
            $notification = array(
                'message' => __('website.wrong-phone-number'),
                'type' => 'error'
            );

            return back()->with($notification);
        }
        $phone = $request->phone;

        return redirect()->route('website.verify', $phone);
    }

    public function code($lang, $phone)
    {

        return view('Website.auth.verify', compact('phone'));
    }

    public function verifyCode(VerifyCodeRequest $request)
    {
//        dd($request->all());

        $check = VerificationCode::checkCode($request->phone, $request->code, Constant::VERIFICATION_OBJECTIVE['Verify'])->first();

        if (!$check) {
            $notification = array(
                'message' => __('website.wrong-code'),
                'type' => 'error'
            );

            return back()->with($notification);
        }
        $user = User::checkUserExist($request->phone)->first();

        if (auth()->user()) {
            $user=auth()->user();
            $user->update([
                'phone' => $request->phone
            ]);
        }

        $user->update(['verified' => Constant::USER_STATUS['Verified']]);

        $check->update(['used' => Constant::VERIFICATION_USED['Used']]);

        $user['token'] = $user->createToken('token' . $user->id)->plainTextToken;


        if(auth()->user()){
            Auth::login($user);

            $notification = array(
                'message' => __('website.updated-successfully'),
                'type' => 'success'
            );

            return redirect()->route('website.profile',auth()->id())->with($notification);

        }
        Auth::login($user);

        $notification = array(
            'message' => __('website.logged-in-successfully'),
            'type' => 'success'
        );

        return redirect()->route('website.index')->with($notification);


    }

    public function logout()
    {
        Auth::logout();
        return redirect(route('website.index'));

    }

    public function profile()
    {
        $country = Country::where('country_code', auth()->user()->country_code)->first()->iso_code;

        return view('Website.auth.profile', compact('country'));

    }

    public function updateProfile(UpdateUserProfileRequest $request)
    {

        auth()->user()->update(Arr::except($request->validated(), ['image', 'phone']));
        if (auth()->user()->phone != $request->phone) {
            try {

                VerificationService::verifyAccount(
                    auth()->user()->id,
                    Constant::VERIFICATION_OBJECTIVE['Verify'],
                    Constant::VERIFICATION_INFORMATION_TYPE['Phone'],
                    $request->phone,
                    $request->country_code

                );
            } catch (Exception $exception) {
                $notification = array(
                    'message' => __('website.wrong-phone-number'),
                    'type' => 'error'
                );

                return back()->with($notification);
            }
            $phone = $request->phone;

            return redirect()->route('website.verify', $phone);

        }

        if ($request->image) {
            if (auth()->user()->hubFiles()->exists()) {
                deleteImage(auth()->user()->hubFiles->get_folder_file(), auth()->user()->hubFiles());
            }

            storeImage([
                'value' => $request->image,
                'folderName' => Constant::USER_IMAGE_FOLDER_NAME,
                'model' => auth()->user(),
                'saveInDatabase' => true

            ]);
        }

        $notification = array(
            'message' => __('website.updated-successfully'),
            'type' => 'success'
        );

        return redirect()->back()->with($notification);
    }

    public function lastSeenAds()
    {
        $advertisements = auth()->user()->advertisementsActionsByType(Constant::ADVERTISEMENT_USER_TYPE['View'])->paginate(20);
        return view('Website.auth.last-seen-ads', compact('advertisements'));

    }

    public function followedShops()
    {
        $shops = auth()->user()->followings()->paginate(20);
        return view('Website.auth.followed-shops', compact('shops'));

    }

    public function blockedShops()
    {
        //ADVERTISEMENT_USER_TYPE
        $shops = auth()->user()->blockedStores()->paginate(20);
//        dd($shops);
        return view('Website.auth.blocked-shops', compact('shops'));

    }

    public function favorites($lang)
    {
//        $advertisements=AdvertisementService::advertisementsBasedOnParameters([
//            'usersActionsType'  => Constant::ADVERTISEMENT_USER_TYPE['Favorite'],
//            'limit'             => 20,
//            'user_id'           => auth()->id(),
//            'paginate'          => true
//        ]);
//        dd($advertisements);

        return view('Website.auth.favorites');

    }

    public function lastSearch()
    {

        $advertisements = auth()->user()->advertisementsActionsByType(Constant::ADVERTISEMENT_USER_TYPE['Search'])->paginate();
        return view('Website.auth.last-search', compact(
            'advertisements'));

    }


}
