<?php

namespace App\Http\Controllers\Website;

use App\Http\Requests\Website\V100\AddBlogCommentRequest;
use App\Models\Blog;
use App\Models\BlogComment;
use App\Services\Website\CountryService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;

class BlogsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $selectedCountry=CountryService::selectCountry();

        $popularPosts=Blog::orderBy('share_count','desc')->whereHas('countries',function ($query)use($selectedCountry){
            $query->where('countries.id',$selectedCountry->id);
        })->withCount('comments')->take(3)->get();

        $blogs = Blog::orderBy('created_at', 'desc')->whereHas('countries',function ($query)use($selectedCountry){
            $query->where('countries.id',$selectedCountry->id);
        })->with('author')->paginate(20);
        return view('Website.pages.blogs.view-all-blogs', compact(
            'blogs','popularPosts'));

    }

    public function show($lang,$id)
    {
        $blog = Blog::whereId($id)->with(['author', 'comments'=>function($query){
            $query->with('user');
        }])->first();
         $relatedBlogs=Blog::where('id','!=',$id)->orderBy('created_at','desc')->take(2)->get();
        return view('Website.pages.blogs.blog-details', compact(
            'blog','relatedBlogs'));

    }
    public function addComment(AddBlogCommentRequest $request,$blog_id){
        BlogComment::create($request->validated()+['user_id'=>auth()->id(),'blog_id'=>$blog_id]);
        $notification=array(
            'message'=>__('website.comment-added-successfully'),
            'alert-type'=>'success'
        );

        return redirect()->back()->with($notification);
    }


}
