<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Website\V100\FilterAdvertisementsRequest;
use App\Http\Requests\Website\V100\FilterShopsRequest;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\Country;
use App\Models\Package;
use App\Models\Property;
use App\Models\Setting;
use App\Models\Story;
use App\Models\User;
use Illuminate\Http\Request;
use MongoDB\Driver\Session;

class GetAdvertisementDetailsController extends Controller
{
    public function __invoke($lang,$id, $slug)
    {
        $type=request()->type=='View'?Constant::ADVERTISEMENT_USER_TYPE['View']:Constant::ADVERTISEMENT_USER_TYPE['Search'];
        if (auth()->user()) {
            auth()->user()->advertisementsActions()->attach($id, ['type' => $type]);
     
            $type == Constant::ADVERTISEMENT_USER_TYPE['View'] ?
                Advertisement::find($id)->increment('views_count') :
                Advertisement::find($id)->increment('search_count');
        }
        $advertisement = Advertisement::where('id', $id)
            ->with(['shop' => function ($query) {
                $query->withCount(['advertisements', 'followers'])->with('categories');
            }, 'properties'=>function($query){
                $query->with('parent');
            }])
            ->withCount(['users as is_favorite'=>function ($query) {

                $query->where(['type' => Constant::ADVERTISEMENT_USER_TYPE['Favorite'], 'user_id' => auth()->id()]);
            }])
            ->first();
//        return $advertisement->images();
        //$advertisement->subCategory
        $relatedShops = User::CheckUserType(Constant::USER_TYPE['Store'])->orderBy('average_rate')
            ->withCount('advertisements')
            ->withCount(['followers as is_follow' => function ($query) {
                $query->where('follower_id', auth()->id());
            }])
            ->whereHas('categories', function ($query) use ($advertisement) {
                $query->where('category_id', $advertisement->subCategory->category->id);
            })

            ->with('categories')
            ->take(6)->get();
        $relatedAdvertisements =
            Advertisement::where('sub_category_id', $advertisement->sub_category_id)
                ->orderBy('premium', 'desc')
                ->take(6)
                ->with(['subCategory','city','shop'])
                ->get();
        $safetyTips=Setting::where('key',Constant::SETTING_KEYS['Security tips'])->first();
        $advertisementsReports=Setting::where('key',Constant::SETTING_KEYS['Advertisement Reports'])->get();

        return view('Website.pages.advertisements.advertisement-details',
            compact('advertisement', 'relatedShops', 'relatedAdvertisements',
                'safetyTips','advertisementsReports','type'));


    }
}
