<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Models\Advertisement;
use App\Models\Blog;
use App\Models\Category;
use App\Models\Country;
use App\Models\Package;
use App\Models\Setting;
use App\Models\Story;
use App\Models\User;
use App\Services\Website\AdvertisementService;
use App\Services\Website\CountryService;
use App\Services\Website\ShopService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class GetHomeController extends Controller
{
    public function __invoke(Request $request,$lang)
    {
        $selectedCountry=CountryService::selectCountry();
        $advertisements=AdvertisementService::advertisement(
            $request,
            $selectedCountry,
            null,
            null,
            true,
            true)
            ->get();

        $mostPopularAdvertisements=$advertisements;
        $suggestedAdvertisements=$advertisements->sortByDesc('favorite_count')->sortByDesc('views_count');
        $shopQuery=ShopService::shops($selectedCountry);
        $shops =$shopQuery->get();
        $followedShops = $shopQuery->whereHas('followers',function ($query){
            $query->where('follower_id', auth()->id());
        })->get();


        $packages = Package::active()->where('country_id',$selectedCountry->id)->take(3)
            ->with('country')->get();
        $blogs = Blog::whereHas('countries',function ($query)use($selectedCountry){
            $query->where('countries.id',$selectedCountry->id);
        })->orderBy('created_at', 'desc')->take(6)->get();
        dd(\Illuminate\Support\Facades\Session::get('country'));

        $colIndex = 3;
        $reverse = 0;
//        dd('home page');
        return view('Website.pages.index', compact(
            'shops', 'suggestedAdvertisements', 'packages', 'blogs',
            'followedShops', 'colIndex', 'reverse','mostPopularAdvertisements'));


    }
}
