<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Requests\Website\V100\ContactUsRequest;
use App\Models\Advertisement;
use App\Models\Blog;
use App\Models\Category;
use App\Models\ContactUs;
use App\Models\Package;
use App\Models\Setting;
use App\Models\Team;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;

class GetSettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function help($lang,$type)
    {
        if ($type == 'help') {
//            return Constant::SETTING_KEYS['Help'];
            $questions = Setting::where('key', Constant::SETTING_KEYS['Help'])->get();
            return view('Website.pages.settings.help', compact('questions'));
        } else {
            $questions = Setting::where('key', Constant::SETTING_KEYS['How to use site'])->get();

            return view('Website.pages.settings.how-to-use', compact('questions'));
        }

    }

    public function contactUs()
    {
        $address = Setting::where('key', Constant::SETTING_KEYS['Address'])->first();
        $phone = Setting::where('key', Constant::SETTING_KEYS['Phone'])->get();
        $email = Setting::where('key', Constant::SETTING_KEYS['Email'])->get();
        $reasons = Setting::where('key', Constant::SETTING_KEYS['Contact us'])->get();
        return view('Website.pages.settings.contact-us', compact(
            'address', 'phone', 'email','reasons'
        ));

    }

    public function submitContactForm(ContactUsRequest $request)
    {
        ContactUs::create($request->validated());
        $notification=array(
            'message'=>__('website.contact-success-message'),
            'alert-type'=>'success'
        );

        return redirect()->back()->with($notification);
    }

    public function about()
    {
        $about = Setting::where('key', Constant::SETTING_KEYS['About us'])->first();
        $sections = Setting::where('key', Constant::SETTING_KEYS['About sections'])->get();
        $users = User::CheckUserType(Constant::USER_TYPE['User'])->count();
        $contacts = ContactUs::count();
         $team = Setting::where('key', Constant::SETTING_KEYS['Team'])->get();

        return view('Website.pages.settings.about', compact(
            'about', 'sections', 'users', 'contacts', 'team'
        ));

    }

    public function terms()
    {
        $terms = Setting::where('key', Constant::SETTING_KEYS['Terms conditions'])->first();
        return view('Website.pages.settings.terms', compact(
            'terms'
        ));

    }

    public function safetySteps()
    {
        $safetySteps = Setting::where('key', Constant::SETTING_KEYS['Security tips'])->first();
        return view('Website.pages.settings.safety-steps', compact(
            'safetySteps'
        ));

    }
    public function paymentMethods()
    {
        return view('Website.pages.settings.payment-method');

    }

    public function subCategories(Request $request)
    {
        $subCategories = Category::where('parent_id', $request->category_id)->get()->pluck('name', 'id');
        return response()->json($subCategories);
    }
}
