<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\Country;
use App\Models\Package;
use App\Models\Story;
use App\Models\User;
use App\Services\Website\CountryService;
use Illuminate\Http\Request;

class GetStoriesController extends Controller
{
    public function __invoke()
    {
        $selectedCountry=CountryService::selectCountry();

        $stories=User::checkUserType(Constant::USER_TYPE['Store'])
            ->with(['newStories', 'stories' => function ($query) {
                $query->with('hubFiles');
            }])

            ->whereHas('city',function ($query)use($selectedCountry){
                $query->where('parent_id',$selectedCountry->id);
            })
            ->whereHas('newStories')->with('newStories')->orderBy('average_rate')->paginate(20);
       return view('Website.pages.stories.view-all-stories',compact('stories'
          ));


    }
}
