<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckGuardAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        if (\Route::is('store*') && auth('admin')->check() && auth('admin')->user()->store_id == null) {
            auth('admin')->logout();

            return redirect()->route('store.login');
        }

        if (\Route::is('admin*') && auth('admin')->check() && auth('admin')->user()->store_id != null) {
            auth('admin')->logout();

            return redirect()->route('admin.login');
        }

        return $next($request);
    }
}
