<?php

namespace App\Http\Middleware;

use App\Services\Website\CountryService;
use Closure;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;

class SetLocale
{
    // ...
//    private $locales = ['ar', 'en'];

    // ...
    public function handle($request, Closure $next)
    {
        dd(request()->getHost(),$host = $request->getSchemeAndHttpHost());
        $selectedCountry = CountryService::selectCountry();
            if($request->url()!='https://'.strtolower($selectedCountry->iso_code).'.mtest.my-staff.net/'.app()->getLocale()){

                return Redirect::to('https://' . strtolower($selectedCountry->iso_code) . '.mtest.my-staff.net/'.app()->getLocale());
            }

        dd(Session::get('counrty'));


        $segments = $request->segments();
        $languages=Config::get('translatable.locales');
        if(in_array($segments[0],$languages)) {
            app()->setLocale($segments[0]);
        }else{
            app()->setLocale($languages[1]);

        }
        URL::defaults(['locale' => app()->getLocale()]);

        if ($segments) {
            if (count($segments) > 1 && $segments[1] == 'change-language') {
                $referrer = url()->previous();
                return Redirect::to($this->toggleUrl($referrer));
            }
        }
        return $next($request);

    }
    private function getNewUrl(string $referrer, string $from, string $to): string
    {

        if (request()->language == $from) {
            return str_replace('/' .$to  , '/' . $from , $referrer);
        }
        return str_replace('/' .$to  , '/' . $from , $referrer);
    }

    /**
     * @param string $referrer
     * @return string
     */
    private function toggleUrl(string $referrer): string
    {
        if (app()->getLocale() == 'ar') {
            return $this->getNewUrl($referrer, 'en', 'ar');
        }
        return $this->getNewUrl($referrer, 'ar', 'en');
    }

}

