<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ValidateHeaderRequest
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if(! $request->header('countryId') &&
            !request()->is('api/v1/countries') &&
            !request()->is('api/v1/categories') &&
            !request()->is('api/v1/settings') &&
            !request()->is('api/v1/auth/*') &&
            !request()->is('api/ajax/*')
        ) {
            return response()->json(['message' => "You must send the 'countryId' key in the request header"], 401);
        }

        return $next($request);
    }
}
