<?php

namespace App\Http\Requests\Website\V100;

use App\Helpers\Constant;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class AddCommentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'rate' => [
                'required'
            ],
            'review'  => ['required', 'min:1', 'max:150'],
            'store_id'=>['nullable','exists:users,id'],
            'advertisement_id'=>['nullable','exists:advertisements,id']
        ];
    }
}
