<?php

namespace App\Http\Requests\Website\V100;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ContactUsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'    => ['required_if:type,==,0','max:50'],
            'email'   => ['required','email'],
            'message'    => ['required_if:type,==,0','max:150'],
            'type'    => ['required','in:0,1'],
            'reason_id'    => ['required_if:type,==,0'],

        ];
    }
}
