<?php

namespace App\Http\Resources\Advertisement;

use App\Http\Resources\Country\CountryResource;
use App\Http\Resources\User\StoreResource;
use Illuminate\Http\Resources\Json\JsonResource;

class PropertyResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'        => $this->id,
            'parent'    => new PropertyResource($this->whenLoaded('parent')),
            'name'      => $this->name,
            'text'      => $this->pivot?->text
        ];
    }
}
