<?php

namespace App\Http\Resources\Category;

use App\Helpers\Constant;
use App\Http\Resources\Advertisement\AdvertisementResource;
use App\Http\Resources\User\StoreResource;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\User;
use App\Services\Advertisement\AdvertisementService;
use App\Services\User\StoreService;
use Illuminate\Http\Resources\Json\ResourceCollection;

class SubCategoryCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'ads_count'     => Category::with('translation')->withCount('advertisements')->find($request->category_id)->advertisements_count,
            'stores'        => $this->collection,
            'advertisements'=> AdvertisementService::advertisementsBasedOnParameters([
                'category_id'   => $request->category_id,
                'premium'       => true,
                'limit'         => 5
            ])
        ];
    }
}
