<?php

namespace App\Http\Resources\Story;

use App\Http\Resources\Advertisement\AdvertisementResource;
use App\Http\Resources\User\StoreResource;
use Illuminate\Http\Resources\Json\JsonResource;

class StoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'mime_type'     => $this->hubFiles->getMimeType,
            'file'          => $this->file(),
            'created_at'    => $this->created_at->diffForHumans(),
            'is_seen'       => auth('sanctum')->user() && auth('sanctum')->user()->stories()->exists($this->id),
            'store'         => new StoreResource($this->whenLoaded('store'))
        ];
    }
}
