<?php

namespace App\Http\Resources\User;

use App\Http\Resources\Advertisement\AdvertisementResource;
use App\Http\Resources\Category\CategoryResource;
use App\Http\Resources\Country\CountryResource;
use App\Http\Resources\Story\StoryResource;
use Illuminate\Http\Resources\Json\JsonResource;

class StoreResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'                    => $this->id,
            'name'                  => $this->name,
            'nickname'              => $this->nickname,
            'email'                 => $this->email,
            'phone'                 => $this->phone,
            'country_code'          => $this->country_code,
            'website'               => $this->website,
            'latitude'              => $this->latitude,
            'longitude'             => $this->longitude,
            'token'                 => $this->token,
            'average_rate'          => $this->average_rate,
            'rate_count'            => $this->rate_count,
            'advertisements_count'  => (int)$this->advertisements_count,
            'followers_count'       => (int)$this->followers_count,
            'views_count'           => (int)$this->advertisements_sum_views_count,
            'is_following'          => auth('sanctum')->user() && auth('sanctum')->user()->followings()->exists($this->id),
            'image'                 => $this->image(),
            'background_image'      => $this->background_image,
            'social_media_links'    => $this->social_media_links,
            'working_hours'         => $this->working_hours,
            'advertisements'        => AdvertisementResource::collection($this->whenLoaded('advertisements')),
            'description'           => $this->description,
            'created_at'            => $this->created_at->diffForHumans(),
            'category'              => CategoryResource::collection($this->whenLoaded('categories')),
            $this->mergeWhen($this->relationLoaded('city'), function () {
                return [
                    'country'       => new CountryResource($this->city->country),
                    'city'          => new CountryResource($this->city),
                ];
            }),
            $this->mergeWhen($this->relationLoaded('stories'), function () {
                return [
                    'stories'       => StoryResource::collection($this->stories->load('hubFiles')),
                ];
            }),
        ];
    }
}
