<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'verified'      => $this->verified,
            'name'          => $this->name,
            'email'         => $this->email,
            'phone'         => $this->phone,
            'country_code'  => $this->country_code,
            'image'         => $this->image(),
            'token'         => $this->token,
        ];
    }
}
