<?php

namespace App\Models;

use App\Helpers\Constant;
use Illuminate\Database\Eloquent\Model;

class Advertisement extends Model
{
    protected $fillable = [
        'store_id',
        'city_id',
        'sub_category_id',
        'title',
        'slug',
        'price',
        'premium',
        'is_negotiable',
        'views_count',
        'favorite_count',
        'share_count',
        'latitude',
        'longitude',
        'average_rate',
        'rate_count',
        'description',
    ];

    protected $dates = ['created_at'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function city()
    {
        return $this->belongsTo(Country::class, 'city_id');
    }
    public function shop()
    {
        return $this->belongsTo(User::class, 'store_id');
    }


    public function subCategory()
    {
        return $this->belongsTo(Category::class, 'sub_category_id');
    }

    public function scopeSubCategory($query, $subCategoryId)
    {
        $query->where('sub_category_id', $subCategoryId);
    }

    public function scopePremium($query, $premium = Constant::PREMIUM_STATUS['False'])
    {
        $query->where('premium', $premium);
    }

    public static function getAdvertisementBasedOnSubCategory($subCategoryId, $premium = Constant::PREMIUM_STATUS['False'])
    {
        return self::where(['sub_category_id' => $subCategoryId , 'premium' => $premium]);
    }

    public static function getAdvertisementBasedOnCountry($country_id)
    {
        $cities = Country::find($country_id)->getActiveCities()->pluck('id');

        return self::whereIn('city_id', $cities);
    }

    public function properties()
    {
        return $this->belongsToMany(Property::class)
            ->withPivot('text')
            ->withTimestamps();
    }

    public function image()
    {
        $this->load('hubFiles');

        return $this->hubFiles()->first()->get_path();
    }

    public function images()
    {
        $this->load('hubFiles');

        $imagesArr = [];
        foreach($this->hubFiles as $image) {
            $imagesArr[] = $image->get_path();
        }

        return $imagesArr;
    }

    public function hubFiles()
    {
        return $this->morphMany(HubFile::class, 'morphable');
    }

    public function users()
    {
        return $this->belongsToMany(User::class)->withTimestamps();
    }

    public function reviews()
    {
        return $this->morphMany(Review::class, 'reviewable');
    }

}
