<?php

namespace App\Models;

use App\Helpers\Constant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Explore extends Model
{
    use HasFactory;

    protected $fillable = [
        'store_id'
    ];

    public function file()
    {
        return $this->hubFiles->get_path();
    }

    public function store()
    {
        return $this->belongsTo(User::class, 'store_id');
    }

    public function hubFiles()
    {
        return $this->morphOne(HubFile::class, 'morphable');
    }

    public function users()
    {
        return $this->belongsToMany(User::class)
            ->withPivot('type')
            ->withTimestamps();
    }

    public function likes()
    {
        return $this->belongsToMany(User::class)
            ->wherePivot('type', Constant::EXPLORE_USER_TYPE['Like']);
    }

    public function shares()
    {
        return $this->belongsToMany(User::class)
            ->wherePivot('type', Constant::EXPLORE_USER_TYPE['Share']);
    }

    public function comments()
    {
        return $this->hasMany(ExploreComment::class);
    }
}
