<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    public function store()
    {
        return $this->belongsTo(User::class,'action_by_id');
    }
    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }
    public function advertisement()
    {
        return $this->belongsTo(Advertisement::class,'action_by_id');
    }
    public function hubFiles()
    {
        return $this->morphOne(HubFile::class, 'morphable');
    }
    public function image()
    {
        $this->load('hubFiles');

        return $this->hubFiles?->get_path();
    }
    public function getCreatedAtAttribute(){
        return Carbon::createFromTimeStamp(strtotime($this->attributes['created_at']))->diffForHumans();
    }


}
