<?php

namespace App\Models;

use App\Helpers\Constant;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    use Translatable;

    public $translatedAttributes = ['title', 'description'];

    protected $fillable = [
        'country_id',
        'active',
        'period',
        'advertisements_count',
        'advertisements_premium_count',
        'price',
    ];
    protected $with='translations';

    public function scopeActive($query)
    {
        $query->where('active', Constant::CATEGORY_STATUS['Active']);
    }
    public function country(){
        return $this->belongsTo(Country::class);
    }
}
