<?php

namespace App\Models;

use App\Helpers\Constant;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Property extends Model
{
    use HasFactory, Translatable;

    public $translatedAttributes = ['name'];

    protected $fillable = [
        'type',
        'parent_id',
        'is_category_type',
    ];
    protected $with = 'translations';

    public function parent()
    {
        return $this->belongsTo(Property::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(Property::class, 'parent_id');
    }

    public function hubFiles()
    {
        return $this->morphOne(HubFile::class, 'morphable');
    }

    public function advertisements()
    {
        return $this->belongsToMany(Advertisement::class, 'advertisement_property');
    }
    public function categories()
    {
        return $this->belongsToMany(Category::class,'category_property');
    }

}
