<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Story extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'store_id',
        'expired_at',
    ];

    protected $dates = ['created_at'];

    public function file()
    {
        return $this->hubFiles?->get_path();
    }
    public function store()
    {
        return $this->belongsTo(User::class, 'store_id');
    }

    public function hubFiles()
    {
        return $this->morphOne(HubFile::class, 'morphable');
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function views()
    {
        return $this->belongsToMany(User::class, 'story_views')
            ->withTimestamps();
    }

    public function getSpecialStore($limit, $category_id = null)
    {
        return
        $this->when($category_id, function ($query) use ($category_id) {
            $query->where('category_id', $category_id);
        })
        ->where('expired_at', '>', now())
        ->with('hubFiles', 'store')
        ->paginate($limit);
    }
}
