<?php

namespace App\Providers;

use App\Helpers\Constant;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\Country;
use App\Models\Notification;
use App\Models\Setting;
use App\Models\User;
use App\Services\Advertisement\AdvertisementService;
use App\View\Composers\HeaderComposer;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
//        config(['selectedCountry' => $company]);

//        Model::preventLazyLoading(app()->isProduction());
//dd(Session::get('locale'));
        Schema::defaultStringLength(191);

        ini_set('serialize_precision', 14);
        ini_set('precision', 14);
        View::composer(
          "*",
            HeaderComposer::class
        );

        $langs = ['en','ar'];
        $default = $langs[1];
        $locale = request()->segment(1);

        if (in_array($locale, $langs)) {

            app()->setLocale($locale);
        } else {
            app()->setLocale($default);

        }

        Paginator::useBootstrap();

    }
}
