<?php

namespace App\Services\User;

use App\Helpers\Constant;
use App\Http\Resources\User\StoreResource;
use App\Models\User;

class StoreService
{
       /**
        * Return the users with type store based om paramters.
        *
        * @param  Array  $data ['category_id', 'premium', 'followings', 'most_rated', 'limit']
        */
    public static function storesBasedOnParameters($data)
    {
        $stores =
        User::getVerifiedUserBasedOnType(Constant::USER_TYPE['Store'])
        ->when($data['category_id'] ?? false, function ($query) use($data) {
            $query->whereHas('categories', function ($query) use ($data) {
                $query->where('category_id', $data['category_id']);
            });
        })
        ->when($data['premium'] ?? false == Constant::PREMIUM_STATUS['True'], function ($query) use($data) {
            $query->where('premium', Constant::PREMIUM_STATUS['True']);
        })
        ->when($data['followers'] ?? false, function ($query) use($data) {
            $query->whereHas('followers', function ($query) use ($data) {
                $query->where('follower_id', auth('sanctum')->id());
            });
        })
        ->when($data['most_rated'] ?? false, function ($query) use($data) {
            $query->orderBy('average_rate', 'desc');
        });

        if ($data['paginate'] ?? false) {
            return $stores->paginate($data['limit']);
        }

        return $stores->take($data['limit'])->get();
    }
}
