<?php


namespace App\Services\Website;


use App\Helpers\Constant;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\Country;
use Illuminate\Support\Facades\Session;

class CategoryService
{
    public static function categories($selectedCountry)
    {

        return

            Category::
            getActiveCategories()
            ->with([
            'categoryAdvertisements' => function ($query)use($selectedCountry) {

                $query
                    ->when(auth()->user(), function ($query) {
                        auth()->user()->blockedStores->each(function ($store) use ($query) {
                            $query->whereNotIn('advertisements.id', $store->advertisements->pluck('id'));
                        });
                    })

                    ->with(['subCategory' => function ($query)use($selectedCountry) {
                        $query->with('category')
                            ->withCount('advertisements');
                    },
                        'city'=>function($query){
                        $query->with('country');
                        }, 'shop' ])
                    ->whereHas('city',function ($query)use($selectedCountry){
                        $query->where('parent_id',$selectedCountry->id);
                    });
            }
        ,'subCategories'=>function($query){
                $query->withCount('advertisements');
            }])
                ->select('id','app_home')
                ->withCount(['shops','categoryAdvertisements'])

                ->get()

           ->sortByDesc('category_advertisements_count');




    }

}
