<?php

namespace App\Http\Controllers\Api\V100\Explore;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Explore\SetExploreUserCommentRequest;
use App\Http\Requests\Api\V100\Explore\SetExploreUserRequest;
use App\Http\Resources\Explore\ExploreCommentsResource;
use App\Http\Resources\Explore\ExploreResource;
use App\Models\Explore;
use App\Models\ExploreComment;
use App\Services\RespondActive;

class ExploreController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:sanctum')->only('store', 'storeComment', 'destroyComment');
    }

    public function index()
    {
        $data = ExploreResource::collection(
            Explore::with('hubFiles', 'store')
                ->when(auth('sanctum')->user(), function ($query) {
                    auth('sanctum')->user()->blockedStores->each(function ($store) use ($query) {
                        $query->whereNotIn('id', $store->explores->pluck('id'));
                    });
                })
                ->withCount('likes', 'comments', 'shares')
                ->inRandomOrder()
                ->paginate()
        )->response()->getData();

        return RespondActive::success('The action ran successfully!', $data);
    }

    public function store(SetExploreUserRequest $request)
    {
        $explore = Explore::find($request->explore_id);

        if ($explore->users()->where(['user_id' => auth()->id(), 'type' => $request->type])->exists() && $request->type == Constant::EXPLORE_USER_TYPE['Like']) {

            $explore->users()->where(['user_id' => auth()->id(), 'type' => $request->type])->detach(auth()->id());
        } else {
            $explore->users()->attach(auth()->id(), ['type' => $request->type]);
        }

        return RespondActive::success('The action ran successfully!');
    }

    public function comments(Explore $explore)
    {
        $comments = ExploreCommentsResource::collection(
            $explore->comments()->with('user')->paginate()
        )->response()
        ->getData();

        return RespondActive::success('The action ran successfully!', $comments);
    }

    public function storeComment(SetExploreUserCommentRequest $request)
    {
        $comment = Explore::find($request->explore_id)->comments()->create([
            'comment'   => $request->comment,
            'user_id'   => auth()->id()
        ]);

        $comment = new ExploreCommentsResource($comment);

        return RespondActive::success('The action ran successfully!', $comment);
    }

    public function destroyComment(ExploreComment $comment)
    {
        if ($comment->user_id == auth()->id()){
            $comment->delete();
        }

        return RespondActive::success('The action ran successfully!');
    }
}
