<?php

namespace App\Http\Resources\Explore;

use App\Helpers\Constant;
use App\Http\Resources\Advertisement\AdvertisementResource;
use App\Http\Resources\User\StoreResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ExploreResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'mime_type'     => $this->hubFiles->getMimeType,
            'file'          => $this->file(),
            'likes_count'   => $this->likes_count,
            'comments_count'=> $this->comments_count,
            'shares_count'  => $this->shares_count,
            'is_liked'      => auth('sanctum')->user() &&
                auth('sanctum')->user()
                ->exploreActions(Constant::EXPLORE_USER_TYPE['Like'])
                ->where('explore_id', $this->id)
                ->exists(),
            'store'         => new StoreResource($this->whenLoaded('store'))
        ];
    }
}
