<?php


namespace App\Services\Website;


use App\Helpers\Constant;
use App\Models\Advertisement;
use App\Models\Country;
use Illuminate\Support\Facades\Session;

class FilterService
{
    public static function countData($query,$request,$selectedCountry,$category,$selectedCategory,$relation='advertisements')
    {

        return
            $query->
            withCount([$relation => function ($query) use ($request, $selectedCountry, $category, $selectedCategory) {

                $query->whereHas('city', function ($query) use ($selectedCountry) {
                    $query->where('parent_id', $selectedCountry->id);
                })
                    ->when($category && $category != 'all', function ($query) use ($category, $selectedCategory) {
                        if ($selectedCategory && $selectedCategory->parent_id != null) {
                            $query->whereHas('subCategory', function ($query) use ($category) {
                                $query->whereTranslation('slug', $category);
                            });

                        } else {
                            $query->whereHas('subCategory', function ($query) use ($category) {
                                $query->whereHas('category', function ($query) use ($category) {
                                    $query->whereTranslation('slug', $category);
                                });
                            });

                        }
                    })
                    ->when($request->sub_category_id && $request->sub_category_id[0] != null, function ($query) use ($request) {
                        $query->whereIn('sub_category_id', $request->sub_category_id);
                    })
                    ->when($request->category_id && $request->category_id[0] != null, function ($query) use ($request) {
                        $query->whereHas('subcategory', function ($query) use ($request) {
                            $query->whereIn('parent_id', $request->category_id);
                        });
                    })
                    ->when($request->text, function ($query) use ($request) {
                        $query->where('title', 'Like', '%' . $request->text . '%');
                    })
                    ->when($request->min_price && $request->max_price, function ($query) use ($request) {
                        $query->whereBetween('price', [$request->min_price, $request->max_price]);
                    })
                    ->when($request->city_id && $request->city_id[0] != null, function ($query) use ($request) {
                        $query->whereIn('city_id', $request->city_id);
                    })
                    ->when($request->properties, function ($query) use ($request) {
                        $query->whereHas('properties', function ($query) use ($request) {
                            $query->whereIn('advertisement_property.property_id', $request->properties);

                        });
                    })
                    ->when(isset($request->advertisement_type) && in_array(Constant::FILTER_ADVERTISEMENT_TYPE['Premium'], $request->advertisement_type), function ($query) use ($request) {
                        $query->where('premium', Constant::PREMIUM_STATUS['True']);
                    })
                    ->when(isset($request->advertisement_type) && in_array(Constant::FILTER_ADVERTISEMENT_TYPE['Free'], $request->advertisement_type), function ($query) use ($request) {
                        $query->where('premium', Constant::PREMIUM_STATUS['False']);
                    })
                    ->when($request->pages, function ($query) use ($request) {
                        $query->take($request->pages);
                    })
                    ->when($request->sortBy && $request->sortBy == 'rated', function ($query) use ($request) {
                        $query->orderBy('average_rate', 'desc');
                    })
                    ->when($request->sortBy && $request->sortBy == 'price', function ($query) use ($request) {
                        $query->orderBy('price', 'desc');
                    })
                    ->when($request->sortBy && $request->sortBy == 'date', function ($query) use ($request) {
                        $query->orderBy('created_at', 'desc');
                    })
                    ->when($request->sortBy && $request->sortBy == 'default', function ($query) use ($request) {
                    })
                    ->when(auth()->user(), function ($query) {
                        auth()->user()->blockedStores->each(function ($store) use ($query) {
                            $query->whereNotIn('advertisements.id', $store->advertisements->pluck('id'));
                        });
                    })

                    ->with(['subCategory' => function ($query) {
                        $query->with('category');
                    }, 'city', 'shop']);
            }]);

    }

}
