<?php


namespace App\View\Composers;


use App\Helpers\Constant;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\Country;
use App\Models\Setting;
use App\Models\User;

//use App\Services\Advertisement\AdvertisementService;
use App\Services\Website\AdvertisementService;
use App\Services\Website\CategoryService;
use App\Services\Website\CountryService;
use Illuminate\Support\Facades\Session;
use Illuminate\View\View;
use League\Flysystem\Config;

class HeaderComposer
{

    public function compose(View $view)
    {
        $selectedCountry = CountryService::selectCountry();

        $advertisements = AdvertisementService::advertisement(
            null,
            $selectedCountry,
            null,
            null,
            false,
            null,
            null,
            false
        )->get();
        $minPrice = $advertisements->min('price');
        $maxPrice = $advertisements->max('price');
        $advertisementsCount = $advertisements->count();
        $viewsCount = $advertisements->sum('views_count');


        $cities =
            Country::GetActiveCities()
            ->where('parent_id', $selectedCountry->id)
            ->whereHas('shops')
            ->withCount(['shops', 'advertisements'])
            ->get();
        $allCountries = Country::GetActiveCountries()->get();

        $categories =CategoryService::categories($selectedCountry);
        $usersCount = User::checkUserType(Constant::USER_TYPE['User'])->verified()->count();
        $settings = Setting::
        whereIn('key',
            [
                Constant::SETTING_KEYS['Address'],
                Constant::SETTING_KEYS['Phone'],
                Constant::SETTING_KEYS['Email'],
                Constant::SETTING_KEYS['Suggested ads'],
                Constant::SETTING_KEYS['Most popular ads'],
                Constant::SETTING_KEYS['Meta']
            ])->orderBy('key')->get()->keyBy('key');
        $socialMedia=Setting::where('key',Constant::SETTING_KEYS['Social media'])->get();

        $notifications = auth()->user() ? auth()->user()->notifications()->orWhere('all_users', 1)->orderBy('created_at', 'desc')->where('created_at', '>=', auth('sanctum')->user()->created_at)
            ->get() : 0;
        $favorites = auth()->user() ? \App\Services\Advertisement\AdvertisementService::advertisementsBasedOnParameters([
            'usersActionsType'  => Constant::ADVERTISEMENT_USER_TYPE['Favorite'],
            'limit'             => 20,
            'user_id'           => auth()->id(),
            'paginate'          => true
        ]): 0;


        $view->with([
            'cities' => $cities,
            'categories' => $categories,
            'maxPrice' => $maxPrice,
            'minPrice' => $minPrice,
            'usersCount' => $usersCount,
            'advertisementsCount' => $advertisementsCount,
            'viewsCount' => $viewsCount,
            'allCountries' => $allCountries,

            'socialMedia' => $socialMedia,
            'favorites' => $favorites,
            'notifications' => $notifications,
            'settings' => $settings,
            'selectedCountry' => $selectedCountry,
        ]);
    }
}

