var telInput = $("#phone"),
    errorMsg = $("#error-msg"),
    validMsg = $("#valid-msg"),
    countryCodeNewInput = document.createElement("INPUT"),
    phoneWithInput = document.createElement("INPUT"),
    fullPhoneInput = document.createElement("INPUT"),
    loginForm = $("#login-form"),
    loginButton = $("#login");


// initialise plugin
telInput.intlTelInput({

    allowExtensions: true,
    formatOnDisplay: true,
    autoFormat: true,
    autoHideDialCode: true,
    autoPlaceholder: true,
    defaultCountry: "auto",
    ipinfoToken: "yolo",
    hiddenInput: "full_phone",

    nationalMode: true,
    numberType: "MOBILE",
    placeholderNumberType : "MOBILE",
    //onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
    preferredCountries: ['sa', 'ae', 'qa','om','bh','kw','ma'],
    preventInvalidNumbers: true,
    separateDialCode: true,
    initialCountry: "auto",
    geoIpLookup: function(callback) {
        $.get("https://ipinfo.io", function() {}, "jsonp").always(function(resp) {
            var countryCode = (resp && resp.country) ? resp.country : "";
            callback(countryCode);

        });
    },
    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js"
});

var reset = function() {
    telInput.removeClass("error");
    errorMsg.addClass("hide");
    validMsg.addClass("hide");

};

// on blur: validate
loginButton.on('click',function() {
    reset();

        if ($.trim(telInput.val())) {
        if (telInput.intlTelInput("isValidNumber")) {
            validMsg.removeClass("hide");
            countryCodeNewInput.setAttribute("type", "hidden");
            countryCodeNewInput.setAttribute("name", "country_code");
            countryCodeNewInput.setAttribute("value",$('.selected-dial-code').text());
            loginForm.append(countryCodeNewInput);
            var string = telInput.intlTelInput("getNumber");
            phone = string.replace($('.selected-dial-code').text(),'');
            phoneWithInput.setAttribute("type", "hidden");
            phoneWithInput.setAttribute("name", "phone");
            phoneWithInput.setAttribute("value", phone);
            loginForm.append(phoneWithInput);
            // fullPhoneInput.setAttribute("type", "hidden");
            // fullPhoneInput.setAttribute("name", "full_phone");
            // fullPhoneInput.setAttribute("value", telInput.intlTelInput("getNumber"));
            // loginForm.append(fullPhoneInput);


            loginForm.submit();

        } else {
            telInput.addClass("error");
            errorMsg.removeClass("hide");

        }
    }
});
telInput.on('keypress',function(e) {
    reset();
    if(e.which == 13) {

        if ($.trim(telInput.val())) {
            if (telInput.intlTelInput("isValidNumber")) {
                validMsg.removeClass("hide");
                countryCodeNewInput.setAttribute("type", "hidden");
                countryCodeNewInput.setAttribute("name", "country_code");
                countryCodeNewInput.setAttribute("value", $('.selected-dial-code').text());
                loginForm.append(countryCodeNewInput);
                var string = telInput.intlTelInput("getNumber");
                phone = string.replace($('.selected-dial-code').text(), '');
                phoneWithInput.setAttribute("type", "hidden");
                phoneWithInput.setAttribute("name", "phone");
                phoneWithInput.setAttribute("value", phone);
                loginForm.append(phoneWithInput);
                // fullPhoneInput.setAttribute("type", "hidden");
                // fullPhoneInput.setAttribute("name", "full_phone");
                // fullPhoneInput.setAttribute("value", telInput.intlTelInput("getNumber"));
                // loginForm.append(fullPhoneInput);


                loginForm.submit();

            } else {
                telInput.addClass("error");
                errorMsg.removeClass("hide");

            }
        }
    }
});

// on keyup / change flag: reset
telInput.on("keyup change", reset);
