@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/bookmark.css')}}">


@endsection

@section('banner')
    <section class="single-banner dashboard-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.favorites')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.favorites')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('page-title')
    {{__('website.favorites')}}
@endsection

@section('content')
    <div id="content-section">
    @if(count($favorites)>0)
    <section class="bookmark-part" id="favorites">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card-header">
                        <h5 class="card-title">
                            {{__('website.favorites')}}({{count($favorites)}})
                        </h5>
                    </div>
                </div>
            </div>
            @if(count($favorites))
            <div class="row">
                @foreach($favorites as $favorite)
                <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3" id="favorite-section-{{$favorite->id}}">
                    <div class="product-card">
                        <div class="product-card">
                            <div class="product-media">
                                <a href="{{route('website.advertisement-details',['id'=>$favorite->id,'slug'=>$favorite->slug,'type'=>'View'])}}">
                                    <div class="product-img"><img src="{{$favorite->image()}}"
                                                                  alt="product"></div>
                                </a>
                                <div class="cross-vertical-badge product-badge"><i
                                        class="fas fa-clipboard-check"></i><span>{{__('website.recommend')}}</span>
                                </div>
                                <div class="product-type"><span
                                        class="flat-badge booking">@if($favorite->is_negotiable==0) {{__('website.negotiable')}} @else {{__('website.not-negotiable')}} @endif
                                    </span></div>
                                <ul class="product-action">
                                    <li class="view"><i
                                            class="fas fa-eye"></i><span>{{$favorite->views_count}}</span>
                                    </li>
                                    <li class="click"><i class="fas fa-heart"></i><span>{{$favorite->favorite_count}}</span></li>
                                    <li class="rating"><i class="fas fa-star"></i><span>{{$favorite->average_rate}}/5</span>
                                    </li>
                                </ul>
                            </div>
                            <div class="product-content">
                                <ol class="breadcrumb product-category">
                                    <li><i class="fas fa-tags"></i></li>
                                    <li class="breadcrumb-item"><a href="{{route('website.all-advertisements',['category'=>$favorite->subCategory->category->slug,'type'=>'View'])}}">{{$favorite->subCategory->category->name}}</a></li>
                                    <li class="breadcrumb-item active" aria-current="page"><a href="{{route('website.all-advertisements',['category'=>$favorite->subCategory->slug,'type'=>'View'])}}">{{$favorite->subCategory->name}}</a></li>
                                </ol>
                                <h5 class="product-title"><a
                                        href="{{route('website.advertisement-details',['id'=>$favorite->id,'slug'=>$favorite->slug,'type'=>'View'])}}">{{$favorite->title}}</a>
                                </h5>
                                <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>
                                        {{$favorite->city->name}}</span><br><span><i class="fas fa-clock"></i>{{$favorite->created_at}}</span>
                                </div>
                                <div class="product-info">
                                    <h5 class="product-price">{{$favorite->price}} {{$favorite->city->country->currency}}
                                    </h5>
                                    <div class="product-btn">
                                        <a href="tel:{{$favorite->shop->phone}}" title="call"
                                           class="fas fa-phone-alt"></a>
{{--                                        <a href="{{$favorite->store_id}}" title="chat"--}}
{{--                                           class="fas fa-comments"></a>--}}
                                        <button

                                            onclick="favorite({{$favorite->id}})"
                                            type="button" title="{{__('website.wishlist')}}" class="fas far fa-heart" id="favorite{{$favorite->id}}">

                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            @endif
            <div class="row">
                <div class="col-lg-12">
                    <div class="footer-pagection">
                        <p class="page-info">{{__('website.Showing')}} {{$favorites->total()}} {{__('website.of')}}  {{$favorites->perPage()}}{{__('website.results')}}</p>
                        {{$favorites->links()}}
                    </div>
                </div>
            </div>
        </div>
    </section>
    @else
        @include('Website.pages.errors.empty')

    @endif
    </div>0
 @endsection
