@extends('Website.layouts.app')
@section('extra-css')

    <link rel="stylesheet" href="{{asset('website/css/custom/bookmark.css')}}">

@endsection
@section('page-title')
    {{__('website.followed-shops')}}
@endsection

@section('banner')
    <section class="inner-section single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.followed-shops')}}
                        </h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.followed-shops')}}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <div id="content-section">

    @if(count($shops)>0)
    <section class="inner-section ad-list-part" id="shops">
        <div class="container">
            <div class="row content-reverse">

                <div class="col-lg-12 col-xl-12">
                    <div class="card-header">
                        <h5 class="card-title">{{__('website.followed-shops')}}
                           (<span id="followers-count">{{count($shops)}}</span>) </h5>
                    </div>

                    <div class="row justify-content-left">
                        @foreach($shops as $shop)

                        <div class="col-md-11 col-lg-8 col-xl-4" id="follow-section-{{$shop->id}}">
                            <div class="product-card standard">
                                <div class="product-media shop-media">
                                    <div class="product-img shop-img">
                                        <img src="{{$shop->image()}}" alt="{{$shop->name}}">
                                    </div>


                                </div>
                                <div class="product-content">
                                    <ol class="breadcrumb product-category">
                                        <li><i class="fas fa-tags"></i></li>
                                        @foreach($shop->categories as $category)
                                            <li class="breadcrumb-item"><a>{{$category->name}}</a></li>
                                        @endforeach
{{--                                        <li class="breadcrumb-item active" aria-current="page">house</li>--}}
                                    </ol>
                                    <h5 class="product-title"><a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">{{$shop->name}}</a></h5>
                                    <div class="product-meta"><span><i class="fas fa-eye"></i>{{$shop->views_count}} {{__('website.views')}}</span><span><i
                                                class="fas fa-bullhorn"></i>{{$shop->advertisements_count}} {{__('website.ads')}}</span></div>

                                    <button type="submit"
                                            onclick="follow({{$shop->id}})"
                                            class="btn btn-inline post-btn unfollow-btn"  ><i
                                            class="fas fa-user-times"></i><span>  {{__('website.un-follow')}} </span>
                                    </button>
                                </div>
                            </div>

                        </div>
                        @endforeach
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="footer-pagection">
                                <p class="page-info">{{__('website.Showing')}} {{$shops->total()}} {{__('website.of')}}  {{$shops->perPage()}}{{__('website.results')}}</p>
                                {{$shops->links()}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @else
        @include('Website.pages.errors.empty')

    @endif
        </div>
@endsection
