@extends('Website.layouts.app')
@section('extra-css')

    <link rel="stylesheet" href="{{asset('website/css/custom/bookmark.css')}}">

@endsection
@section('page-title')
    {{__('website.last-search')}}
@endsection
@section('banner')
    <section class="inner-section single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.last-search')}}
                        </h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.last-search')}}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection

@section('content')
    @if(count($advertisements)>0)

        <section class="bookmark-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card-header">
                        <h5 class="card-title">
                            {{__('website.search-result')}}
                            ({{$advertisements}})</h5>
                    </div>
                </div>
            </div>
            @if(count($advertisements)>0)
                <div class="row">
                    @foreach($advertisements as $advertisement)
                        <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                            <div class="product-card">
                                <div class="product-media">
                                    <a href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}?type=Search">
                                        <div class="product-img"><img src="{{$advertisement->image()}}"
                                                                      alt="product"></div>
                                    </a>
                                    <div class="cross-vertical-badge product-badge"><i
                                            class="fas fa-clipboard-check"></i><span>{{__('website.recommend')}}</span>
                                    </div>
                                    <div class="product-type"><span
                                            class="flat-badge booking">{{$advertisement->name}}</span></div>
                                    <ul class="product-action">
                                        <li class="view"><i
                                                class="fas fa-eye"></i><span>{{$advertisement->views_count}}</span>
                                        </li>
                                        <li class="click"><i class="fas fa-heart"></i><span>134</span></li>
                                        <li class="rating"><i class="fas fa-star"></i><span>{{$advertisement->average_rate}}/5</span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="product-content">
                                    <ol class="breadcrumb product-category">
                                        <li><i class="fas fa-tags"></i></li>
                                        <li class="breadcrumb-item"><a
                                                href="{{$advertisement->subCategory->slug}}">{{$advertisement->subCategory->name}}</a>
                                        </li>
                                    </ol>
                                    <h5 class="product-title"><a
                                            href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}?type=Search">{{$advertisement->title}}</a>
                                    </h5>
                                    <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>
                                        {{$advertisement->city->name}}</span><span><i class="fas fa-clock"></i>{{$advertisement->created_at}}</span>
                                    </div>
                                    <div class="product-info">
                                        <h5 class="product-price">{{$advertisement->price}}
                                            <span>/{{__('website.per-day')}}</span></h5>
                                        <div class="product-btn">
                                            <a href="tel:{{$advertisement->shop->phone}}" title="call"
                                               class="fas fa-phone-alt"></a>
{{--                                            <a href="{{$advertisement->store_id}}" title="chat"--}}
{{--                                               class="fas fa-comments"></a>--}}
                                            <button type="button" title="whatsapp"
                                                    onclick="location.href='https://api.whatsapp.com/send?phone={{$advertisement->phone}}'"
                                                    class="fab fa-whatsapp no-top" tabindex="0"></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="footer-pagection">
                            <p class="page-info">{{__('website.Showing')}} {{$advertisements->total()}} {{__('website.of')}}  {{$advertisements->perPage()}}{{__('website.results')}}</p>
                            {{$advertisements->links()}}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>

    @else
        @include('Website.pages.errors.empty')

    @endif

@endsection
