@extends('Website.layouts.app')
@section('page-title')
    {{$blog->title}}
@endsection
@section('meta-deep-link')


    <link rel="icon" href="{{$blog->image()}}" type="image/x-icon">
    <link rel="shortcut icon" href="{{$blog->image()}}" type="image/x-icon">

    <meta property="og:title" content="{{$blog->title}}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{Request::fullUrl()}}">
    <meta property="og:site_name" content="{{Request::url()}}">
    <meta property="og:description" content="{{substr(strip_tags($blog->description),1,50)}}">
    <meta property="og:image" itemprop="image" content="{{$blog->image()}}">
    <meta property="og:image:secure_url" itemprop="image" content="{{$blog->image()}}">
    <meta property="og:image:width" content="300"/>
    <meta property="og:image:height" content="170"/>
    <meta property="og:image:type" content="image/webp"/>
    <meta property="og:image:alt" content="{{$blog->title}}">

    <meta property="og:updated_time" content="1440432930"/>
    <meta property="article:tag" content="{{$blog->title}}">
    <meta property="article:section" content="{{$blog->meta_description}}">
    <meta property="article:published_time" content="{{$blog->created_at}}">
    <meta property="article:modified_time" content="{{$blog->updated_at}}">

    <meta property="twitter:title" content="{{$blog->title}}">
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:description" content="{{$blog->meta_description}}">
    <meta property="twitter:site" content="@moon">
    <meta property="twitter:creator" content="@moon">
    <meta property="twitter:image" content="{{$blog->image()}}">
    <meta property="twitter:image:alt" content="{{$blog->title}}">
@endsection

@section('extra-css')
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/blog-details.css'):asset('website/css/custom/blog-details-rtl.css')}}">


@endsection
@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{$blog->title}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>
                            <li class="breadcrumb-item"><a
                                    href="{{route('website.view-all-blogs')}}">{{__('website.blog-list')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{$blog->title}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('content')
    <section class="blog-details-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <div class="blog-details-title">
                        <h2><a>{{$blog->title}}</a></h2>
                    </div>
                    <ul class="blog-details-meta">
                        <li><a rel="author"><i class="far fa-user"></i>
                                <p>{{$blog->author->name}}</p>
                            </a></li>
                        <li>
                            <a><i class="far fa-calendar-alt"></i>
                                <p>{{$blog->created_at}}</p>
                            </a>
                        </li>
                        {{--                        <li>--}}
                        {{--                            <a ><i class="far fa-comments"></i>--}}
                        {{--                                <p>{{count($blog->comments)}} {{ __('website.comments')}} </p>--}}
                        {{--                            </a>--}}
                        {{--                        </li>--}}
                        <li><a><i class="far fa-share-square"></i>
                                <p>{{$blog->share_count." ".__('website.shares')}}</p>
                            </a></li>
                    </ul>
                    <div class="blog-details-image"><img src="{{$blog->image()}}" alt="{{$blog->title}}"></div>
                    <div class="blog-details-content">
                        <div class="description">
                            <p>{!! $blog->description  !!}</p>
                        </div>
                        <ul class="blog-details-meta">

                            <li>
                                <a> {{__('website.updated_at')}}
                                    :
                                    <p>{{$blog->updated_at}}</p>
                                </a>
                            </li>
                        </ul>

                        {{--                        <div class="sub-content">--}}
                        {{--                            <h3>How to manage your advertise?</h3>--}}
                        {{--                            <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Eos quasi deleniti voluptatem--}}
                        {{--                                sint incidunt quos corporis recusandae repudiandae aspernatur voluptates omnis illum--}}
                        {{--                                quaerat quidem veritatis, facilis enim quis quo ipsam ipsa doloribus, nostrum adipisci--}}
                        {{--                                eligendi <a href="#">consequuntur</a>consequatur. Animi molestias ab ex eius, doloremque--}}
                        {{--                                corporis sunt alias non deleniti doloribus</p>--}}
                        {{--                        </div>--}}
                        {{--                        <div class="quote-content">--}}
                        {{--                            <p>{{$blog->quote}}</p>--}}
                        {{--                            <h5><a >{{$blog->author->name}}</a></h5>--}}
                        {{--                        </div>--}}
                        {{--                        <ul class="list-content">--}}
                        {{--                            <li>--}}
                        {{--                                <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Delectus quaerat tenetur, <a--}}
                        {{--                                        href="#">aperiam</a>odit, ratione eligendi nulla quae praesentium quo, a--}}
                        {{--                                    reiciendis inventore facilis veniam voluptates.</p>--}}
                        {{--                            </li>--}}
                        {{--                            <li>--}}
                        {{--                                <p>Lorem ipsum dolor, sit amet consectetur adipisicing elit. Ad ullam impedit,--}}
                        {{--                                    architecto porro voluptas sequi ab beatae saepe quo magnam</p>--}}
                        {{--                            </li>--}}
                        {{--                            <li>--}}
                        {{--                                <p>Lorem ipsum dolor sit amet consectetur adipisicing elit Ad ullam impedit architecto--}}
                        {{--                                    porro.</p>--}}
                        {{--                            </li>--}}
                        {{--                        </ul>--}}
                    </div>
                    <div class="blog-details-widget">

                        <ul class="share-list">
                            <li>
                                <h4>{{__('website.share')}}:</h4>
                            </li>
                            <li>
                                <a href="https://www.facebook.com/sharer.php?u={{route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])}}"><i
                                        class="fab fa-facebook-f"></i></a></li>
                            <li>
                                <a href="https://twitter.com/intent/tweet?text={{$blog->title}}&url={{route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])}}"><i
                                        class="fab fa-twitter"></i></a></li>
                            {{--                            <li><a href="https://api.whatsapp.com/send/?phone={{$blog->phone}}&text={{__('website.chatting-for-text').route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])}}&app_absent=0"><i class="fab fa-whatsapp"></i></a></li>--}}
                            {{--                            <li><a href="#"><i class="fab fa-behance"></i></a></li>--}}
                            {{--                            <li><a href="#"><i class="fab fa-pinterest-p"></i></a></li>--}}
                        </ul>
                    </div>
                    @if(count($relatedBlogs)>0)
                        <div class="row">
                            @foreach($relatedBlogs as $relatedBlog)
                                <div class="col-md-6 col-lg-6">
                                    <div class="blog-card">
                                        <div class="blog-img"><img src="{{$relatedBlog->image()}}" alt="blog">
                                        </div>
                                        <div class="blog-content"><a class="blog-avatar">
                                                <img src="{{ $relatedBlog->author->image ?? defaultMoonImage() }}"
                                                     alt="{{$blog->author->name}}"></a>
                                            <ul class="home-blog">
                                                <li><i class="fas fa-user"></i>
                                                    <p><a rel="author">{{$relatedBlog->author->name}}</a></p>
                                                </li>
                                                <li><i class="fas fa-clock"></i>
                                                    <p>{{$relatedBlog->created_at}}</p>
                                                </li>
                                            </ul>
                                            <div class="blog-text">
                                                <h4>
                                                    <a href="{{route('website.blog-details',['id'=>$relatedBlog->id,'slug'=>$relatedBlog->slug])}}">{{$blog->title}}</a>
                                                </h4>
                                                <p>{{substr(strip_tags($relatedBlog->description),1,50)}}....</p>
                                            </div>
                                            <a href="{{route('website.blog-details',['id'=>$relatedBlog->id,'slug'=>$relatedBlog->slug])}}"
                                               class="blog-read"><span>{{__('website.read-more')}}</span><i
                                                    class="fas fa-long-arrow-alt-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    @endif

                    {{--                    <div class="blog-details-comment">--}}
                    {{--                        <div class="comment-title">--}}
                    {{--                            <h3>{{__('website.comments')}} ({{count($blog->comments)}})</h3>--}}
                    {{--                        </div>--}}
                    {{--                        <div class="common-card" id="review">--}}

                    {{--                            <div class="ad-details-review">--}}
                    {{--                                @if(count($blog->comments)>0)--}}
                    {{--                                <ul class="review-list">--}}
                    {{--                                    @foreach($blog->comments as $comment)--}}
                    {{--                                    <li class="review-item">--}}
                    {{--                                        <div class="review-user">--}}
                    {{--                                            <div class="review-head">--}}
                    {{--                                                <div class="review-profile">--}}
                    {{--                                                    <a class="review-avatar">--}}
                    {{--                                                        <img src="{{$comment->user->image()?$comment->user->image():'/website/images/favicon.png'}}" alt="{{$comment->user->name}}"></a>--}}
                    {{--                                                    <div class="review-meta">--}}
                    {{--                                                        <h6><a >{{$comment->user->name}}</a><br><span>{{$comment->created_at}}</span></h6>--}}
                    {{--                                                    </div>--}}
                    {{--                                                </div>--}}
                    {{--                                            </div>--}}
                    {{--                                            <p class="review-desc">{{chunk_split($comment->comment,50)}}</p>--}}
                    {{--                                        </div>--}}
                    {{--                                    </li>--}}
                    {{--                                    @endforeach--}}
                    {{--                                </ul>--}}
                    {{--                                @endif--}}
                    {{--                                @if(auth()->user())--}}
                    {{--                                <div class="form-title">--}}
                    {{--                                    <h3>{{__('website.leave-your-comment')}}</h3>--}}
                    {{--                                </div>--}}
                    {{--                                <form class="review-form" action="{{route('website.add-blog-comment',$blog->id)}}" method="post">--}}
                    {{--                                  @csrf--}}
                    {{--                                    <div class="form-group">--}}
                    {{--                                        <textarea class="form-control" name="comment" placeholder="Review"></textarea>--}}
                    {{--                                    </div>--}}
                    {{--                                    <button type="submit" class="btn btn-inline review-submit"><span>--}}
                    {{--                                            {{__('website.write-comment')}}</span></button>--}}
                    {{--                                </form>--}}

                    {{--                                    @endif--}}
                    {{--                            </div>--}}
                    {{--                        </div>--}}
                    {{--                    </div>--}}

                </div>
            </div>
        </div>
    </section>

@endsection
