@extends('Website.layouts.app')
@section('page-title')
    {{__('website.categories')}}
@endsection

@section('banner')
    <section class="inner-section single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.categories')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>

                            <li class="breadcrumb-item active" aria-current="page">{{__('website.all-categories')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <section class="inner-section category-part">
        <div class="container">
            <div class="row">
                @if(count($allCategories)>0)
                    @foreach($allCategories as $category)
                        <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                            <div class="category-card">
                                <div class="category-head">
                                    <img src="{{$category->image()}}" alt="category">
                                    <a href="{{$category->slug}}" class="category-content">
                                        <h4>{{$category->name}}</h4>
                                        <p>({{$category->category_advertisements_count}})</p>
                                    </a>
                                </div>
                                <ul class="category-list">
                                    @foreach($category->subCategories->sortByDesc('advertisements_count') as $subCategory)

                                        <li><a href="{{route('website.all-advertisements',$subCategory->slug)}}?type=Search">
                                                <h6>{{$subCategory->name}}</h6>
                                                <p>({{$subCategory->advertisements_count}})</p>
                                            </a></li>
                                    @endforeach
                                </ul>

                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="footer-pagection">
                        <p class="page-info">{{__('website.Showing')}} {{$allCategories->total()}} {{__('website.of')}}  {{$allCategories->perPage()}}{{__('website.results')}}</p>

                        {{$allCategories->links()}}

                    </div>

                </div>
            </div>


        </div>
    </section>

@endsection

