@extends('Website.layouts.app')
@section('page-title')
    {{__('website.cities')}}
@endsection

@section('banner')
    <section class="inner-section single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.stores-by-cities')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.cities')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <section class="inner-section city-part">
        <div class="container">
            @if(count($cities)>0)
                <div class="row">
                    @foreach($cities as $key=>$city)

                        <div class="col-sm-6 col-md-6 col-lg-{{$colIndex}}">
                            <a href="{{route('website.all-shops',$city->slug)}}" class="city-card"
                               style="background: url({{$city->image()}}) no-repeat center; background-size: cover">
                                <div class="city-content">
                                    <h4>{{$city->name}}</h4>
                                    <p>({{$city->shops_count}}) {{__('website.shops')}}</p>
                                </div>
                            </a>
                        </div>

                        @if($colIndex==3 && $reverse==0)
                            @php $colIndex++; @endphp


                        @elseif($colIndex==4 && $reverse==0)
                            @php $colIndex++; @endphp

                        @elseif($colIndex==5 && $reverse==0)
                            @php $colIndex=5; @endphp
                            @php $reverse=1; @endphp

                        @elseif($colIndex==5 && $reverse==1)
                            @php $colIndex--; @endphp

                        @elseif($colIndex==4 && $reverse==1)
                            @php $colIndex--; @endphp

                        @elseif($colIndex==3 && $reverse==1)
                            @php $colIndex=3; @endphp
                            @php $reverse=0; @endphp
                        @endif



                    @endforeach
                </div>
            @endif

        </div>
    </section>

@endsection
