@extends('Website.layouts.app')
@section('page-title')
    {{__('website.home-page')}}
@endsection

@section('banner')
    <section class="banner-part">
        <div class="container">
            <div class="banner-content">
                <h1>{{__('website.banner-title')}}</h1>
                <p>{{__('website.banner-description')}}</p>
                <a href="{{route('website.all-categories')}}" class="btn btn-inline"><i class="fas fa-eye"></i><span>
                        {{__('website.view-all-categories')}}
                    </span></a>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <section class="suggest-part hidden-small-2 ">
        <div class="container">
            <div class="suggest-slider slider-arrow">
                @if(count($categories)>0)
                    @foreach($categories->where('app_home', 1) as $category)
                        <a href="{{route('website.all-advertisements',$category->slug)}}?type=View" class="suggest-card">
                            <img src="{{$category->image()}}" alt="{{$category->name}}" width="100px" height="100px">
                            <h6>{{$category->name}}</h6>
                            <p>({{$category->category_advertisements_count}}) {{__('website.ads')}}</p>
                        </a>
                    @endforeach
                @endif

            </div>
        </div>
    </section>
    <section class="section recomend-part d-lg-none d-md-none">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2> &nbsp; <span>{{__('website.moon')}}</span> {{__('website.categories')}}</h2>
                        <p>
                            {{__('website.banner-description')}}
                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="container">
                        @if(count($categories)>0)
                            @foreach($categories->where('app_home', 1) as $category)

                                <a href="{{route('website.all-advertisements',['category'=>$category->slug,'type'=>'view'])}}" class="suggest-card suggest-card-mobile  ">

                                    <img
                                        src="{{$category->image()}}" alt="{{$category->name}}">
                                    <h6>{{$category->name}}</h6>
                                    <p>({{$category->category_advertisements_count}}) {{__('website.ads')}}</p>
                                </a>
                            @endforeach
                        @endif

                    </div>
                </div>
            </div>

        </div>
    </section>

    <section class="section recomend-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2><span>{{__('website.moon')}}</span> &nbsp; {{__('website.shop-stories')}}</h2>
                        <p>
                            {{__('website.shop-stories-desc')}}
                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">

                    <div id="stories" class="storiesWrapper"></div>
                    <div class="center-50"><a href="{{route('website.all-stories')}}" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span> {{__('website.view-all-stories')}} </span></a></div>
                </div>
            </div>

        </div>


    </section>
    <section class="section category-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2>{{__('website.top-categories-by')}} &nbsp;<span>{{__('website.ads')}}</span></h2>
                        <p>
                            {{__('website.top-categories-desc')}}
                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                @if(count($categories)>0)
                    @foreach($categories->where('app_home', 1) as $category)
                        <div class="col-sm-6 col-md-6 col-lg-4 col-xl-3">
                            <div class="category-card">
                                <div class="category-head">
                                    {{--                                    <picture>--}}
                                    {{--                                        <source--}}
                                    {{--                                            media="(min-width: 650px)"--}}
                                    {{--                                            srcset="images/kitten-stretching.png">--}}
                                    {{--                                        <source--}}
                                    {{--                                            media="(min-width: 465px)"--}}
                                    {{--                                            srcset="images/kitten-sitting.png">--}}
                                    {{--                                        <img--}}
                                    {{--                                            src="{{$category->image()}}"--}}
                                    {{--                                            alt="{{$category->name}}" width="255px" height="200px">--}}
                                    {{--                                    </picture>--}}

                                    <img src="{{$category->image()}}" alt="{{$category->name}}" width="255px" height="200px">
                                    <a href="{{route('website.all-advertisements',$category->slug)}}?type=View"
                                       class="category-content">
                                        <h4>{{$category->name}}</h4>
                                        <p>({{$category->category_advertisements_count}})</p>
                                    </a>
                                </div>
                                <ul class="category-list">
                                    @foreach($category->subCategories->sortByDesc('advertisements_count') as $subCategory)

                                        <li><a href="{{route('website.all-advertisements',$subCategory->slug)}}?type=View">
                                                <h6>{{$subCategory->name}}</h6>
                                                <p>({{$subCategory->advertisements_count}})</p>
                                            </a></li>
                                    @endforeach
                                </ul>

                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-20"><a href="{{route('website.all-categories')}}" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span>{{__('website.view-all-categories')}}</span></a></div>
                </div>
            </div>
        </div>
    </section>
    <section class="section recomend-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2 > {{__('website.top-rated')}} &nbsp;

                            <span> {{__('website.shops')}} </span>

                        </h2>
                        <p>
                            {{__('website.top-rated-desc')}}

                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="recomend-slider slider-arrow">
                        @if(count($shops)>0)
                            @foreach($shops as $shop)
                                <div class="product-card shops ">
                                    <div class=" product-card-no-shaddow">
                                        <div class="product-img">
                                            <a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}" class="home-shop-image"><img
                                                    src="{{$shop->image()}}" alt="{{$shop->name}}" width="256px" height="170px"></a>
                                        </div>

                                    </div>
                                    <div class="product-content">
                                        <ol class="breadcrumb product-category">
                                            <li><i class="fas fa-tags"></i></li>
                                            @foreach($shop->categories as $category)
                                                <li class="breadcrumb-item"><a
                                                        href="{{route('website.all-advertisements',$category->slug)}}?type=View">{{$category->name}}</a></li>
                                            @endforeach
                                        </ol>
                                        <h5 class="product-title"><a
                                                href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">{{$shop->name}}</a>
                                        </h5>
                                        <div class="product-meta"><span><i class="fas fa-eye"></i>{{$shop->views_count}} {{__('website.views')}}</span><span><i
                                                    class="fas fa-bullhorn"></i>{{$shop->advertisements_count}} {{__('website.ads')}}</span>
                                        </div>

                                        @if(auth()->user())
                                            <button type="submit"
                                                    onclick="follow({{$shop->id}})"
                                                    class="btn btn-inline  @if($shop->is_follow==0) btn-secondary @endif  post-btn follow-btn mb-2" id="follow-{{$shop->id}}">
                                                @if($shop->is_follow==0)
                                                    <i
                                                        class="fas fa-user"></i><span> {{__('website.follow')}}  </span>
                                                @else
                                                    <i
                                                        class="fas fa-user-times"></i><span> {{__('website.un-follow')}}  </span>
                                                @endif
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-50"><a href="{{route('website.all-shops','all')}}" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span>{{__('website.view-all-shops')}}</span></a></div>
                </div>
            </div>
        </div>
    </section>
    @if(auth()->user() && count($followedShops)>0)
        <section class="section recomend-part" id="follow-section">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2> {{__('website.followed')}} &nbsp;
                                <span> {{__('website.shops')}} </span></h2>
                            <p>
                                {{__('website.followed-shop-desc')}}


                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            @foreach($followedShops as $shop)
                                <div class="product-card shops" id="follow-section-{{$shop->id}}">
                                    <div class=" product-card-no-shaddow">
                                        <div class="product-img">
                                            <a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}"><img
                                                    src="{{$shop->image()}}" alt="{{$shop->name}}" width="256px" height="170px">
                                            </a>
                                        </div>

                                    </div>
                                    <div class="product-content">
                                        <ol class="breadcrumb product-category">
                                            <li><i class="fas fa-tags"></i></li>
                                            @foreach($shop->categories as $category)
                                                <li class="breadcrumb-item"><a
                                                        href="{{$category->slug}}">{{$category->name}}</a></li>
                                            @endforeach

                                            {{--                                    <li class="breadcrumb-item" aria-current="page">Duplex House</li>--}}
                                        </ol>
                                        <h5 class="product-title">
                                            <a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">{{$shop->name}}</a>
                                        </h5>
                                        <div class="product-meta"><span><i class="fas fa-eye"></i>100 {{__('website.views')}}</span><span><i
                                                    class="fas fa-bullhorn"></i>{{$shop->advertisements_count}} {{__('website.ads')}}</span>
                                        </div>

                                        <button type="button"
                                                onclick="follow({{$shop->id}})"
                                                class="btn btn-inline post-btn follow-btn mb-2" id="follow-{{$shop->id}}"><i
                                                class="fas fa-user-times"></i><span>{{__('website.un-follow')}}</span>
                                        </button>


                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="center-50">
                            <a href="{{route('website.view-all-followed-shops')}}" class="btn btn-inline">
                                <i class="fas fa-eye"></i>
                                <span>{{__('website.view-all-followed-shops')}}</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endif
    @if($settings[\App\Helpers\Constant::SETTING_KEYS['Suggested ads']]->show_app==1)
        <section class="section recomend-part">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2>{{__('website.our-recommended')}} &nbsp;
                                <span>{{__('website.ads')}}</span></h2>
                            <p>
                                {{__('website.our-recommended-ads-desc')}}


                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            {{--                        {{__('website.our-recommended')}}--}}
                            @if(count($suggestedAdvertisements)>0)
                                @foreach($suggestedAdvertisements as $advertisement)
                                    <div class="product-card">
                                        <div class="product-media">
                                            <a href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}?type=View">
                                                <div class="product-img"><img src="{{$advertisement->image()}}"
                                                                              alt="{{$advertisement->title}}" width="256px" height="170px"></div>
                                            </a>
                                            <div class="cross-vertical-badge product-badge"><i
                                                    class="fas fa-clipboard-check"></i><span>{{__('website.recommend')}}</span>
                                            </div>
                                            <div class="product-type"><span
                                                    class="flat-badge booking"> @if($advertisement->premium==1){{__('website.premium')}} @else {{__('website.regular')}} @endif</span></div>
                                            <ul class="product-action">
                                                <li class="view"><i
                                                        class="fas fa-eye"></i><span>{{$advertisement->views_count}}</span>
                                                </li>
                                                <li class="click"><i class="fas fa-heart"></i><span>{{$advertisement->favorite_count}}</span></li>
                                                <li class="rating"><i class="fas fa-star"></i><span>{{$advertisement->average_rate}}/5</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="product-content">
                                            <ol class="breadcrumb product-category">
                                                <li><i class="fas fa-tags"></i></li>
                                                <li class="breadcrumb-item"><a href="{{route('website.all-advertisements',['category'=>$advertisement->subCategory->category->slug,'type'=>'View'])}}">{{$advertisement->subCategory->category->name}}</a>
                                                </li>

                                                <li class="breadcrumb-item active"><a
                                                        href="{{route('website.all-advertisements',['category'=>$advertisement->subCategory->slug,'type'=>'View'])}}">{{$advertisement->subCategory->name}}</a>
                                                </li>
                                            </ol>
                                            <h5 class="product-title"><a
                                                    href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>'View'])}}">{{$advertisement->title}}</a>
                                            </h5>
                                            <div class="product-meta">
                                                <span><i class="fas fa-map-marker-alt"></i>
                                        {{$advertisement->city?$advertisement->city->name:'-'}},{{$advertisement->city&&$advertisement->city->country?$advertisement->city->country->name:'-'}}
                                                </span>
                                                <span><i class="fas fa-clock"></i>{{\Carbon\Carbon::createFromTimeStamp(strtotime($advertisement->created_at))->diffForHumans()}}</span>
                                            </div>
                                            <div class="product-info">
                                                <h5 class="product-price">{{$advertisement->price}} {{$advertisement->city->country->currency}}
                                                </h5>
                                                <div class="product-btn">
                                                    <a href="tel:{{$advertisement->shop->phone}}" title="call"
                                                       class="fas fa-phone-alt"></a>
                                                    {{--                                                    <a href="{{$advertisement->store_id}}" title="chat"--}}
                                                    {{--                                                       class="fas fa-comments"></a>--}}
                                                    <button type="button" title="whatsapp"
                                                            onclick='window.open("https://api.whatsapp.com/send?phone={{$advertisement->phone!=null??$advertisement->shop->phone}}")'
                                                            class="fab fa-whatsapp no-top" tabindex="0"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="center-50"><a href="{{route('website.all-advertisements','all')}}?type=View"
                                                  class="btn btn-inline"><i
                                    class="fas fa-eye"></i><span>{{__('website.view-all-recommend')}}</span></a></div>
                    </div>
                </div>
            </div>
        </section>
    @endif

    @if($settings[App\Helpers\Constant::SETTING_KEYS['Most popular ads']]->show_app==1)
        <section class="section recomend-part">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2>{{__('website.our-trending')}} &nbsp;
                                <span>{{__('website.ads')}}</span></h2>
                            <p>
                                {{__('website.our-trending-ads-desc')}}


                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            {{--                        {{__('website.our-recommended')}}--}}
                            @if(count($mostPopularAdvertisements)>0)
                                @foreach($mostPopularAdvertisements as $mostPopularAdvertisement)
                                    <div class="product-card">
                                        <div class="product-media">
                                            <a href="{{route('website.advertisement-details',['id'=>$mostPopularAdvertisement->id,'slug'=>$mostPopularAdvertisement->slug])}}?type=View">
                                                <div class="product-img"><img src="{{$mostPopularAdvertisement->image()}}"
                                                                              alt="{{$mostPopularAdvertisement->title}}" width="256px" height="170px"></div>
                                            </a>
                                            <div class="cross-vertical-badge product-badge"><i
                                                    class="fas fa-clipboard-check"></i><span>{{__('website.recommend')}}</span>
                                            </div>
                                            <div class="product-type"><span
                                                    class="flat-badge booking"> @if($mostPopularAdvertisement->premium==1){{__('website.premium')}} @else {{__('website.regular')}} @endif</span></div>
                                            <ul class="product-action">
                                                <li class="view"><i
                                                        class="fas fa-eye"></i><span>{{$mostPopularAdvertisement->views_count}}</span>
                                                </li>
                                                <li class="click"><i class="fas fa-heart"></i><span>{{$mostPopularAdvertisement->favorite_count}}</span></li>
                                                <li class="rating"><i class="fas fa-star"></i><span>{{$mostPopularAdvertisement->average_rate}}/5</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="product-content">
                                            <ol class="breadcrumb product-category">
                                                <li><i class="fas fa-tags"></i></li>
                                                <li class="breadcrumb-item"><a href="{{route('website.all-advertisements',['category'=>$mostPopularAdvertisement->subCategory->category->slug,'type'=>'View'])}}">{{$mostPopularAdvertisement->subCategory->category->name}}</a>
                                                </li>

                                                <li class="breadcrumb-item active"><a
                                                        href="{{route('website.all-advertisements',['category'=>$mostPopularAdvertisement->subCategory->slug,'type'=>'View'])}}">{{$mostPopularAdvertisement->subCategory->name}}</a>
                                                </li>
                                            </ol>
                                            <h5 class="product-title"><a
                                                    href="{{route('website.advertisement-details',['id'=>$mostPopularAdvertisement->id,'slug'=>$mostPopularAdvertisement->slug,'type'=>'View'])}}">{{$mostPopularAdvertisement->title}}</a>
                                            </h5>
                                            <div class="product-meta">
                                                <span><i class="fas fa-map-marker-alt"></i>
                                        {{$mostPopularAdvertisement->city?$mostPopularAdvertisement->city->name:'-'}},{{$mostPopularAdvertisement->city&&$mostPopularAdvertisement->city->country?$mostPopularAdvertisement->city->country->name:'-'}}
                                                </span>
                                                <span><i class="fas fa-clock"></i>{{\Carbon\Carbon::createFromTimeStamp(strtotime($mostPopularAdvertisement->created_at))->diffForHumans()}}</span>
                                            </div>
                                            <div class="product-info">
                                                <h5 class="product-price">{{$mostPopularAdvertisement->price}} {{$mostPopularAdvertisement->city->country->currency}}
                                                </h5>
                                                <div class="product-btn">
                                                    <a href="tel:{{$mostPopularAdvertisement->shop->phone}}" title="call"
                                                       class="fas fa-phone-alt"></a>
                                                    {{--                                                    <a href="{{$advertisement->store_id}}" title="chat"--}}
                                                    {{--                                                       class="fas fa-comments"></a>--}}
                                                    <button type="button" title="whatsapp"
                                                            onclick='window.open("https://api.whatsapp.com/send?phone={{$mostPopularAdvertisement->phone!=null??$mostPopularAdvertisement->shop->phone}}")'
                                                            class="fab fa-whatsapp no-top" tabindex="0"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="center-50"><a href="{{route('website.all-advertisements','all')}}?type=View"
                                                  class="btn btn-inline"><i
                                    class="fas fa-eye"></i><span>{{__('website.view-all-trending')}}</span></a></div>
                    </div>
                </div>
            </div>
        </section>

    @endif
    @if(count($categories)>0)
        @foreach($categories->where('app_home', 1) as $category)
            @if(count($category->categoryAdvertisements->take(10))>0)

                <section class="section recomend-part">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="section-center-heading">
                                    <h2>{{$category->name}} &nbsp;
                                        <span>{{__('website.ads')}}</span></h2>
                                    <p>
                                        {{__('website.our-trending-ads-desc')}}

                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="recomend-slider slider-arrow">
                                    @foreach($category->categoryAdvertisements->take(10) as $advertisement)
                                        <div class="product-card">
                                            <div class="product-media">
                                                <a href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}?type=View">
                                                    <div class="product-img"><img
                                                            src="{{$advertisement->image()}}" alt="{{$advertisement->title}}" width="256px" height="170px">
                                                    </div>
                                                </a>
                                                <div class="cross-vertical-badge product-badge"><i
                                                        class="fas fa-clipboard-check"></i><span>{{__('website.recommend')}}</span>
                                                </div>
                                                <div class="product-type"><span
                                                        class="flat-badge booking">@if($advertisement->premium==1){{__('website.premium')}} @else {{__('website.regular')}}@endif</span>
                                                </div>
                                                <ul class="product-action">
                                                    <li class="view"><i
                                                            class="fas fa-eye"></i><span>{{$advertisement->views_count}}</span>
                                                    </li>
                                                    <li class="click"><i class="fas fa-heart
"></i><span>134</span></li>
                                                    <li class="rating"><i class="fas fa-star"></i><span>{{$advertisement->average_rate}}/5</span>
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="product-content">
                                                <ol class="breadcrumb product-category">
                                                    <li><i class="fas fa-tags"></i></li>
                                                    <li class="breadcrumb-item"><a href="{{route('website.all-advertisements',$advertisement->subCategory->slug)}}?type=View">{{$advertisement->subCategory->category->name}}</a>
                                                    </li>
                                                    <li class="breadcrumb-item active"><a
                                                            href="{{route('website.all-advertisements',$advertisement->subCategory->slug)}}?type=View">{{$advertisement->subCategory->name}}</a>
                                                    </li>
                                                </ol>
                                                <h5 class="product-title"><a
                                                        href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}?type=View">{{$advertisement->title}}</a>
                                                </h5>
                                                <div class="product-meta"><span><i
                                                            class="fas fa-map-marker-alt"></i>
                                                                               {{$advertisement->city?$advertisement->city->name:'-'}},{{$advertisement->city&&$advertisement->city->country?$advertisement->city->country->name:'-'}}</span><span><i class="fas fa-clock"></i>{{\Carbon\Carbon::createFromTimeStamp(strtotime($advertisement->created_at))->diffForHumans()}}</span>
                                                </div>
                                                <div class="product-info">
                                                    <h5 class="product-price">{{$advertisement->price}} {{$advertisement->city->country->currency}}
                                                        <span></span></h5>
                                                    <div class="product-btn"><a
                                                            href="tel:{{$advertisement->shop->phone}}" title="call"
                                                            class="fas fa-phone-alt"></a>
                                                        {{--                                                                                                                    <a href="message.html" title="chat"--}}
                                                        {{--                                                                                                                       class="fas fa-comments"></a>--}}
                                                        <button type="button" title="whatsapp"
                                                                class="fab fa-whatsapp no-top" onclick='window.open("https://api.whatsapp.com/send?phone={{$advertisement->phone!=null??$advertisement->shop->phone}}")'></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="center-50"><a
                                        href="{{route('website.all-advertisements',$category->slug)}}?type=View"
                                        class="btn btn-inline"><i
                                            class="fas fa-eye"></i><span> {{__('website.view-all-ads')}} </span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            @endif

        @endforeach
    @endif

    {{--        <section class="section trend-part">--}}
    {{--            <div class="container">--}}
    {{--                <div class="row">--}}
    {{--                    <div class="col-lg-12">--}}
    {{--                        <div class="section-center-heading">--}}
    {{--                            <h2> Popular Trending <span>Ads</span></h2>--}}
    {{--                            <p>Buy and sell everything from used cars to mobile phones and computers, or search for--}}
    {{--                                property, jobs and more in the world with moon.--}}

    {{--                            </p>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                </div>--}}
    {{--                <div class="row justify-content-center">--}}
    {{--                    <div class="col-md-11 col-lg-8 col-xl-6">--}}
    {{--                        <div class="product-card standard">--}}
    {{--                            <div class="product-media">--}}
    {{--                                <a href="ad-details-left.html">  <div class="product-img"><img src="images/product/01.jpg" alt="product"></div></a>--}}
    {{--                                <div class="cross-vertical-badge product-badge"><i--}}
    {{--                                        class="fas fa-bolt"></i><span>trending</span></div>--}}
    {{--                                <div class="product-type"><span class="flat-badge booking">booking</span></div>--}}
    {{--                                <ul class="product-action">--}}
    {{--                                    <li class="view"><i class="fas fa-eye"></i><span>264</span></li>--}}
    {{--                                    <li class="click"><i class="fas fa-heart--}}
    {{--    "></i><span>134</span></li>--}}
    {{--                                    <li class="rating"><i class="fas fa-star"></i><span>4.5/7</span></li>--}}
    {{--                                </ul>--}}
    {{--                            </div>--}}
    {{--                            <div class="product-content">--}}
    {{--                                <ol class="breadcrumb product-category">--}}
    {{--                                    <li><i class="fas fa-tags"></i></li>--}}
    {{--                                    <li class="breadcrumb-item"><a href="#">property</a></li>--}}
    {{--                                    <li class="breadcrumb-item active" aria-current="page">house</li>--}}
    {{--                                </ol>--}}
    {{--                                <h5 class="product-title"><a href="ad-details-left.html">Lorem ipsum dolor sit amet consect--}}
    {{--                                        adipisicing elit</a></h5>--}}
    {{--                                <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>Egypt,--}}
    {{--                                        Dhaka</span><span><i class="fas fa-clock"></i>30 min ago</span></div>--}}
    {{--                                <div class="product-info">--}}
    {{--                                    <h5 class="product-price">$974<span>/ per day</span></h5>--}}
    {{--                                    <div class="product-btn"><a href="tel:01016171926" title="call"--}}
    {{--                                                                class="fas fa-phone-alt"></a>--}}
    {{--                                        <a href="message.html" title="chat" class="fas fa-comments"></a>--}}
    {{--                                        <button type="button" title="whatsapp" class="fab fa-whatsapp no-top"></button>--}}
    {{--                                    </div>--}}
    {{--                                </div>--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                    <div class="col-md-11 col-lg-8 col-xl-6">--}}
    {{--                        <div class="product-card standard">--}}
    {{--                            <div class="product-media">--}}
    {{--                                <a href="ad-details-left.html">  <div class="product-img"><img src="images/product/02.jpg" alt="product"></div></a>--}}
    {{--                                <div class="cross-vertical-badge product-badge"><i--}}
    {{--                                        class="fas fa-bolt"></i><span>trending</span></div>--}}
    {{--                                <div class="product-type"><span class="flat-badge sale">sale</span></div>--}}
    {{--                                <ul class="product-action">--}}
    {{--                                    <li class="view"><i class="fas fa-eye"></i><span>264</span></li>--}}
    {{--                                    <li class="click"><i class="fas fa-heart--}}
    {{--    "></i><span>134</span></li>--}}
    {{--                                    <li class="rating"><i class="fas fa-star"></i><span>4.5/7</span></li>--}}
    {{--                                </ul>--}}
    {{--                            </div>--}}
    {{--                            <div class="product-content">--}}
    {{--                                <ol class="breadcrumb product-category">--}}
    {{--                                    <li><i class="fas fa-tags"></i></li>--}}
    {{--                                    <li class="breadcrumb-item"><a href="#">fashion</a></li>--}}
    {{--                                    <li class="breadcrumb-item active" aria-current="page">shoes</li>--}}
    {{--                                </ol>--}}
    {{--                                <h5 class="product-title"><a href="ad-details-left.html">Lorem ipsum dolor sit amet consect--}}
    {{--                                        adipisicing elit</a></h5>--}}
    {{--                                <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>Egypt,--}}
    {{--                                        Dhaka</span><span><i class="fas fa-clock"></i>30 min ago</span></div>--}}
    {{--                                <div class="product-info">--}}
    {{--                                    <h5 class="product-price">$384<span>/ fixed</span></h5>--}}
    {{--                                    <div class="product-btn"><a href="tel:01016171926" title="call"--}}
    {{--                                                                class="fas fa-phone-alt"></a>--}}
    {{--                                        <a href="message.html" title="chat" class="fas fa-comments"></a>--}}
    {{--                                        <button type="button" title="whatsapp" class="fab fa-whatsapp no-top"></button>--}}
    {{--                                    </div>--}}
    {{--                                </div>--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                    <div class="col-md-11 col-lg-8 col-xl-6">--}}
    {{--                        <div class="product-card standard">--}}
    {{--                            <div class="product-media">--}}
    {{--                                <a href="ad-details-left.html"> <div class="product-img"><img src="images/product/03.jpg" alt="product"></div></a>--}}
    {{--                                <div class="cross-vertical-badge product-badge"><i--}}
    {{--                                        class="fas fa-bolt"></i><span>trending</span></div>--}}
    {{--                                <div class="product-type"><span class="flat-badge sale">sale</span></div>--}}
    {{--                                <ul class="product-action">--}}
    {{--                                    <li class="view"><i class="fas fa-eye"></i><span>264</span></li>--}}
    {{--                                    <li class="click"><i class="fas fa-heart--}}
    {{--    "></i><span>134</span></li>--}}
    {{--                                    <li class="rating"><i class="fas fa-star"></i><span>4.5/7</span></li>--}}
    {{--                                </ul>--}}
    {{--                            </div>--}}
    {{--                            <div class="product-content">--}}
    {{--                                <ol class="breadcrumb product-category">--}}
    {{--                                    <li><i class="fas fa-tags"></i></li>--}}
    {{--                                    <li class="breadcrumb-item"><a href="#">stationary</a></li>--}}
    {{--                                    <li class="breadcrumb-item active" aria-current="page">book</li>--}}
    {{--                                </ol>--}}
    {{--                                <h5 class="product-title"><a href="ad-details-left.html">Lorem ipsum dolor sit amet consect--}}
    {{--                                        adipisicing elit</a></h5>--}}
    {{--                                <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>Egypt,--}}
    {{--                                        Dhaka</span><span><i class="fas fa-clock"></i>30 min ago</span></div>--}}
    {{--                                <div class="product-info">--}}
    {{--                                    <h5 class="product-price">$78<span>/ Negotiable</span></h5>--}}
    {{--                                    <div class="product-btn"><a href="tel:01016171926" title="call"--}}
    {{--                                                                class="fas fa-phone-alt"></a>--}}
    {{--                                        <a href="message.html" title="chat" class="fas fa-comments"></a>--}}
    {{--                                        <button type="button" title="whatsapp" class="fab fa-whatsapp no-top"></button>--}}
    {{--                                    </div>--}}
    {{--                                </div>--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}

    {{--                    <div class="col-md-11 col-lg-8 col-xl-6">--}}
    {{--                        <div class="product-card standard">--}}
    {{--                            <div class="product-media">--}}
    {{--                                <a href="ad-details-left.html">   <div class="product-img"><img src="images/product/04.jpg" alt="product"></div></a>--}}
    {{--                                <div class="cross-vertical-badge product-badge"><i--}}
    {{--                                        class="fas fa-bolt"></i><span>trending</span></div>--}}
    {{--                                <div class="product-type"><span class="flat-badge sale">sale</span></div>--}}
    {{--                                <ul class="product-action">--}}
    {{--                                    <li class="view"><i class="fas fa-eye"></i><span>264</span></li>--}}
    {{--                                    <li class="click"><i class="fas fa-heart--}}
    {{--    "></i><span>134</span></li>--}}
    {{--                                    <li class="rating"><i class="fas fa-star"></i><span>4.5/7</span></li>--}}
    {{--                                </ul>--}}
    {{--                            </div>--}}
    {{--                            <div class="product-content">--}}
    {{--                                <ol class="breadcrumb product-category">--}}
    {{--                                    <li><i class="fas fa-tags"></i></li>--}}
    {{--                                    <li class="breadcrumb-item"><a href="#">Ad-List-Column2</a></li>--}}
    {{--                                    <li class="breadcrumb-item active" aria-current="page">television</li>--}}
    {{--                                </ol>--}}
    {{--                                <h5 class="product-title"><a href="ad-details-left.html">Lorem ipsum dolor sit amet consect--}}
    {{--                                        adipisicing elit</a></h5>--}}
    {{--                                <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>Egypt,--}}
    {{--                                        Dhaka</span><span><i class="fas fa-clock"></i>30 min ago</span></div>--}}
    {{--                                <div class="product-info">--}}
    {{--                                    <h5 class="product-price">$756<span>/ fixed</span></h5>--}}
    {{--                                    <div class="product-btn"><a href="tel:01016171926" title="call"--}}
    {{--                                                                class="fas fa-phone-alt"></a>--}}
    {{--                                        <a href="message.html" title="chat" class="fas fa-comments"></a>--}}
    {{--                                        <button type="button" title="whatsapp" class="fab fa-whatsapp no-top"></button>--}}
    {{--                                    </div>--}}
    {{--                                </div>--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                    <div class="col-md-12 col-lg-12 col-xl-12 ">--}}
    {{--                        <img src="images/google.png" class="img-fluid mb-3">--}}
    {{--                    </div>--}}
    {{--                    <div class="col-md-11 col-lg-8 col-xl-6">--}}
    {{--                        <div class="product-card standard">--}}
    {{--                            <div class="product-media">--}}
    {{--                                <a href="ad-details-left.html"> <div class="product-img"><img src="images/product/05.jpg" alt="product"></div></a>--}}
    {{--                                <div class="cross-vertical-badge product-badge"><i--}}
    {{--                                        class="fas fa-bolt"></i><span>trending</span></div>--}}
    {{--                                <div class="product-type"><span class="flat-badge sale">sale</span></div>--}}
    {{--                                <ul class="product-action">--}}
    {{--                                    <li class="view"><i class="fas fa-eye"></i><span>264</span></li>--}}
    {{--                                    <li class="click"><i class="fas fa-heart--}}
    {{--    "></i><span>134</span></li>--}}
    {{--                                    <li class="rating"><i class="fas fa-star"></i><span>4.5/7</span></li>--}}
    {{--                                </ul>--}}
    {{--                            </div>--}}
    {{--                            <div class="product-content">--}}
    {{--                                <ol class="breadcrumb product-category">--}}
    {{--                                    <li><i class="fas fa-tags"></i></li>--}}
    {{--                                    <li class="breadcrumb-item"><a href="#">gadget</a></li>--}}
    {{--                                    <li class="breadcrumb-item active" aria-current="page">headphone</li>--}}
    {{--                                </ol>--}}
    {{--                                <h5 class="product-title"><a href="ad-details-left.html">Lorem ipsum dolor sit amet consect--}}
    {{--                                        adipisicing elit</a></h5>--}}
    {{--                                <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>Egypt,--}}
    {{--                                        Dhaka</span><span><i class="fas fa-clock"></i>30 min ago</span></div>--}}
    {{--                                <div class="product-info">--}}
    {{--                                    <h5 class="product-price">$245<span>/ Negotiable</span></h5>--}}
    {{--                                    <div class="product-btn"><a href="tel:01016171926" title="call"--}}
    {{--                                                                class="fas fa-phone-alt"></a>--}}
    {{--                                        <a href="message.html" title="chat" class="fas fa-comments"></a>--}}
    {{--                                        <button type="button" title="whatsapp" class="fab fa-whatsapp no-top"></button>--}}
    {{--                                    </div>--}}
    {{--                                </div>--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}
    {{--                    <div class="col-md-11 col-lg-8 col-xl-6">--}}
    {{--                        <div class="product-card standard">--}}
    {{--                            <div class="product-media">--}}
    {{--                                <a href="ad-details-left.html"> <div class="product-img"><img src="images/product/06.jpg" alt="product"></div></a>--}}
    {{--                                <div class="cross-vertical-badge product-badge"><i--}}
    {{--                                        class="fas fa-bolt"></i><span>trending</span></div>--}}
    {{--                                <div class="product-type"><span class="flat-badge rent">rent</span></div>--}}
    {{--                                <ul class="product-action">--}}
    {{--                                    <li class="view"><i class="fas fa-eye"></i><span>264</span></li>--}}
    {{--                                    <li class="click"><i class="fas fa-heart--}}
    {{--    "></i><span>134</span></li>--}}
    {{--                                    <li class="rating"><i class="fas fa-star"></i><span>4.5/7</span></li>--}}
    {{--                                </ul>--}}
    {{--                            </div>--}}
    {{--                            <div class="product-content">--}}
    {{--                                <ol class="breadcrumb product-category">--}}
    {{--                                    <li><i class="fas fa-tags"></i></li>--}}
    {{--                                    <li class="breadcrumb-item"><a href="#">automobile</a></li>--}}
    {{--                                    <li class="breadcrumb-item active" aria-current="page">cycle</li>--}}
    {{--                                </ol>--}}
    {{--                                <h5 class="product-title"><a href="ad-details-left.html">Lorem ipsum dolor sit amet consect--}}
    {{--                                        adipisicing elit</a></h5>--}}
    {{--                                <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>Egypt,--}}
    {{--                                        Dhaka</span><span><i class="fas fa-clock"></i>30 min ago</span></div>--}}
    {{--                                <div class="product-info">--}}
    {{--                                    <h5 class="product-price">$75<span>/ per hour</span></h5>--}}
    {{--                                    <div class="product-btn"><a href="tel:01016171926" title="call"--}}
    {{--                                                                class="fas fa-phone-alt"></a>--}}
    {{--                                        <a href="message.html" title="chat" class="fas fa-comments"></a>--}}
    {{--                                        <button type="button" title="whatsapp" class="fab fa-whatsapp no-top"></button>--}}
    {{--                                    </div>--}}
    {{--                                </div>--}}
    {{--                            </div>--}}
    {{--                        </div>--}}
    {{--                    </div>--}}

    {{--                </div>--}}
    {{--                <div class="row">--}}
    {{--                    <div class="col-lg-12">--}}
    {{--                        <div class="center-20"><a href="ad-list-column3.html" class="btn btn-inline"><i--}}
    {{--                                    class="fas fa-eye"></i><span>view all trend</span></a></div>--}}
    {{--                    </div>--}}
    {{--                </div>--}}
    {{--            </div>--}}
    {{--        </section>--}}

    <section class="section city-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2 class="direction">{{__('website.top-stores-by')}} &nbsp; <span>{{__('website.for-cities')}}</span></h2>
                        <p>
                            {{__('website.top-stores-by-cities-desc')}}
                        </p>
                    </div>
                </div>
            </div>
            @if(count($cities)>0)
                <div class="row">
                    @foreach($cities->take(6) as $key=>$city)

                        <div class="col-sm-6 col-md-6 col-lg-{{$colIndex}}">
                            <a href="{{route('website.all-shops',$city->slug)}}" class="city-card"
                               style="background: url({{$city->image()}}) no-repeat center; background-size: cover">
                                <div class="city-content">
                                    <h4>{{$city->name}}</h4>
                                    <p>({{$city->shops_count}}) {{__('website.shops')}}</p>
                                </div>
                            </a>
                        </div>

                        @if($colIndex==3 && $reverse==0)
                            @php $colIndex++ @endphp


                        @elseif($colIndex==4 && $reverse==0)
                            @php $colIndex++ @endphp

                        @elseif($colIndex==5 && $reverse==0)
                            @php $colIndex=5 @endphp
                            @php $reverse=1 @endphp

                        @elseif($colIndex==5 && $reverse==1)
                            @php $colIndex-- @endphp

                        @elseif($colIndex==4 && $reverse==1)
                            @php $colIndex-- @endphp

                        @elseif($colIndex==3 && $reverse==1)
                            @php $colIndex=3 @endphp
                            @php $reverse=0 @endphp
                        @endif



                    @endforeach
                </div>
            @endif
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-20"><a href="{{route('website.all-cities')}}" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span>{{__('website.view-all-cities')}}</span></a></div>
                </div>
            </div>
        </div>
    </section>

    <section class="intro-part">

    </section>
    <section class="price-part mb-10">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2><span
                                class="secondary-color bolder"> {{__('website.moon')}} </span> &nbsp; {{__('website.packages-title')}}
                        </h2>
                        <p>
                            {{__('website.packages-title-desc')}}


                        </p>
                    </div>
                </div>
            </div>
            <div class="row mb-10">
                @if(count($packages)>0)
                    @foreach($packages as $package)
                        <div class="col-md-6 col-lg-4">
                            <div class="price-card">
                                <div class="price-head"><i class="flaticon-bicycle"></i>
                                    <h3>{{$package->price}} {{$package->country->currency}}</h3>
                                    <h4> {{$package->period}} {{__('website.months')}}</h4>
                                </div>
                                <ul class="price-list">
                                    <li><i class="fas fa-plus"></i>
                                        <p>{{$package->title}}</p>
                                    </li>
                                    <li><i class="fas fa-times"></i>
                                        <p>{{__('website.regular-ads')}} {{$package->advertisements_count}}</p>
                                    </li>
                                    <li><i class="fas fa-times"></i>
                                        <p>{{__('website.premium-ads')}} {{$package->premium_advertisements_count}}</p>
                                    </li>
                                    <li><i class="fas fa-times"></i>
                                        <p>{{__('website.for')}} {{$package->period}} {{__('website.months')}}</p>
                                    </li>
                                </ul>
                                <div class="price-btn"><a target="_blank" href="{{route('store.register')}}"
                                                          class="btn btn-inline"><i
                                            class="fas fa-sign-in-alt"></i><span>{{__('website.register-now')}}</span></a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="center-20"><a href="{{route('website.packages')}}" class="btn btn-inline"><i
                                class="fas fa-eye"></i><span>{{__('website.view-all-prices')}}</span></a></div>
                </div>
            </div>
        </div>
    </section>
    @if(count($blogs)>0)
        <section class="blog-part">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2 class="direction"> {{__('website.read-our')}}
                                &nbsp; <span> {{__('website.recent-articles')}} </span>
                            </h2>
                            <p>
                                {{__('website.recent-articles-text')}}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="blog-slider slider-arrow">
                            @foreach($blogs as $blog)
                                <div class="blog-card">
                                    <div class="blog-img"><img src="{{$blog->image()}}" alt="{{$blog->title}}" width="338px">
                                        <div class="blog-overlay">

                                        </div>
                                    </div>
                                    <div class="blog-content">
                                        <a class="blog-avatar">
                                            <img src="{{ $blog->author->image ?? defaultMoonImage() }}" alt="{{$blog->author->name}}">
                                        </a>
                                        <ul class="home-blog">
                                            <li><i class="fas fa-user"></i>
                                                <p><a>{{$blog->author->name}}</a></p>
                                            </li>
                                            <li><i class="fas fa-clock"></i>
                                                <p>{{$blog->created_at}}</p>
                                            </li>
                                        </ul>
                                        <div class="blog-text">
                                            <h4>
                                                <a href="{{route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])}}">{{$blog->title}}</a>
                                            </h4>
                                            <p>{{substr(strip_tags($blog->description),1,50)}}....</p>
                                        </div>
                                        <a href="{{route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])}}"
                                           class="blog-read"><span>{{__('website.read-more')}}</span><i
                                                class="fas fa-long-arrow-alt-right"></i></a>
                                    </div>
                                </div>

                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="blog-btn"><a href="{{route('website.view-all-blogs')}}" class="btn btn-inline"><i
                                    class="fas fa-eye"></i><span>{{__('website.view-all-blogs')}}</span></a></div>
                    </div>
                </div>
            </div>
        </section>
    @endif

@endsection
@section('extra-js-files')

    <script src="{{asset('website/js/custom/zuck.min.js')}}"></script>
    <script src="{{asset('website/js/custom/script-story.js')}}"></script>
    <script>
        var currentSkin = getCurrentSkin();
        var stories = new Zuck('stories', {
            backNative: true,
            previousTap: true,
            skin: currentSkin['name'],
            autoFullScreen: currentSkin['params']['autoFullScreen'],
            avatars: currentSkin['params']['avatars'],
            paginationArrows: currentSkin['params']['paginationArrows'],
            list: currentSkin['params']['list'],
            cubeEffect: currentSkin['params']['cubeEffect'],
            localStorage: false,
            stories: [
                @if(count($shops)>0)
                @foreach($shops as $shop)
                Zuck.buildTimelineItem(
                    "{{$shop->image()}}",
                    "{{$shop->image()}}",

                    "{{$shop->name}}",
                    "{{$shop->image()}}",

                    timestamp(),
                    [
                            @foreach($shop->stories as $story)
                        ["{{$shop->name}}", "photo", 3, "{{$story->file()}}", " {{$story->file()}}", 'Write A Comment', false, false, timestamp()],
                        @endforeach
                    ]
                ),
                @endforeach
                @endif
                // Zuck.buildTimelineItem(
                //     "gorillaz",
                //     "images/story/client-2.jpg",
                //     "Burger King 2",
                //     "",
                //     timestamp(),
                //     [
                //         ["gorillaz-1", "video", 0, "images/video.mp4", "images/1.jpg", 'message.html', ' Write a comment ' , false, false, timestamp()],
                //         ["gorillaz-2", "photo", 3, "images/1.jpg", "images/1.jpg",  'message.html', ' Write a comment ', false, false, timestamp()],
                //         ["gorillaz-2", "photo", 3, "images/1.jpg", "images/1.jpg",  'message.html', ' Share2 ', ' like ', false, false, timestamp()],
                //
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "ladygaga",
                //     "images/story/client-3.jpg",
                //     "Bufflo",
                //     "",
                //     timestamp(),
                //     [
                //         ["ladygaga-1", "photo", 5, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()],
                //         ["ladygaga-2", "photo", 3, "images/1.jpg", "images/1.jpg", 'http://ladygaga.com', false, false, timestamp()],
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "starboy",
                //     "images/story/client-3.jpg",
                //     "KFC",
                //     "",
                //     timestamp(),
                //     [
                //         ["starboy-1", "photo", 5, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "riversquomo",
                //     "images/story/client-4.jpg",
                //     "Hadrmot",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 10, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test2",
                //     "images/story/client-5.jpg",
                //     "shawermty",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 11, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test",
                //     "images/story/client-6.jpg",
                //     "king BG",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 12, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // ),
                // Zuck.buildTimelineItem(
                //     "test3",
                //     "images/story/client-7.jpg",
                //     "Shrimp Zone",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 13, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test4",
                //     "images/story/client-8.jpg",
                //     "Premos Pizza",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 14, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test5",
                //     "images/story/client-9.jpg",
                //     "El Monofy",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 15, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test6",
                //     "images/story/client-10.jpg",
                //     "Falah Foods",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 16, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test7",
                //     "images/story/client-11.jpg",
                //     "Big Tasty",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 17, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                // ,
                // Zuck.buildTimelineItem(
                //     "test8",
                //     "images/story/client-6.jpg",
                //     "Shrimp",
                //     "",
                //     timestamp(),
                //     [
                //         ["riverscuomo", "photo", 18, "images/1.jpg", "images/1.jpg", '', false, false, timestamp()]
                //     ]
                // )
                //
            ]
        });
    </script>

@endsection
