@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/price.css')}}">
    <link rel="stylesheet" href="{{asset('css/custom/main.css')}}">

<style>
    .price-part{
        margin: 0!important;
    }
</style>
@endsection
@section('page-title')
    {{__('website.packages')}}
@endsection



@section('banner')

<section class="single-banner">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="single-content">
                    <h1>{{__('website.pricing-plans')}}</h1>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('website.packages')}}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
@section('content')
    <section class="best-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2 class="price-heading dark-head">{{__('website.why-create-shop-with')}} <span class="primary-color">{{__('website.moon')}}</span></h2>
                        <p class="price-description">{{__('website.why-create-shop-with-text')}}</p>
                    </div>
                </div>
            </div>
            @if(count($sections))
            <div class="row">
                @foreach($sections as $section)
                    <div class="col-md-6 col-lg-4 col-xl-4">
                        <div class="best-card">
                            <div class="best-icon"><i class="fas fa-check-circle"></i></div>
                            <div class="best-content">
                                <h4>{{$section->title}}</h4>{{$section->content}}
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
                @endif
        </div>
    </section>
 @if(count($packages)>0)
    <section class="price-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2>{{__('website.package-title')}}</h2>
                        <p>
                            {{__('website.package-title-text')}}

                        </p>
                    </div>
                </div>
            </div>
            <div class="row">
                @foreach($packages as $package)

                    <div class="col-md-6 col-lg-4 mb-10">
                        <div class="price-card">
                            <div class="price-head"><i class="flaticon-airplane"></i>
                                <h3>{{$package->price}} {{$package->country->currency}}</h3>
                                <h4> {{$package->period}} {{__('website.months')}}</h4>
                            </div>
                            <ul class="price-list">
                                <li><i class="fas fa-plus"></i>
                                    <p>{{$package->title}}</p>
                                </li>
                                <li><i class="fas fa-times"></i>
                                    <p>{{__('website.regular-ads')}} {{$package->advertisements_count}}</p>
                                </li>
                                <li><i class="fas fa-times"></i>
                                    <p>{{__('website.premium-ads')}} {{$package->premium_advertisements_count}}</p>
                                </li>
                                <li><i class="fas fa-times"></i>
                                    <p>{{__('website.for')}} {{$package->period}} {{__('website.months')}}</p>
                                </li>
                            </ul>
                            <div class="price-btn"><a target="_blank" href="https://moontest.my-staff.net/store/register"
                                                      class="btn btn-inline"><i
                                        class="fas fa-sign-in-alt"></i><span>{{__('website.register-now')}}</span></a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

        </div>
    </section>
@endif
@endsection
