@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/contact.css')}}">
<style>

    .alert {
        position: relative!important;
        padding: .75rem 1.25rem!important;
        margin-bottom: 1rem!important;
        border: 1px solid transparent!important;
        border-radius: .25rem!important;
    }
</style>
@endsection
@section('page-title')
    {{__('website.contact-us')}}
@endsection

@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.contact-us')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.contact-us')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <section class="contact-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="contact-info"><i class="fas fa-map-marker-alt"></i>
                        <h3>{{__('website.find-us')}}</h3>
                        <p>{{$address->content}}</p>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="contact-info"><i class="fas fa-phone-alt"></i>
                        <h3>{{__('website.make-a-call')}}</h3>
                        <p>{{isset($phone[0])?$phone[0]->content:''}} <span>{{isset($phone[1])?$phone[1]->content:''}} </span>
                        </p>


                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="contact-info"><i class="fas fa-envelope"></i>
                        <h3>{{__('website.send-mail')}}</h3>
                        <p>
                            {{isset($email[0])?$email[0]->content:''}}<span>{{isset($email[1])?$email[1]->content:''}} </span></p>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="contact-map">
                        <h3> <span class="secondary-color bolder"> {{__('website.moon')}}</span> {{__('website.main-branch')}}</h3>
                        <p class="mb-3">
                            {{$address->content}}

                        </p>

                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3654.3406974350205!2d90.48469931445422!3d23.663771197998262!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755b0d5983f048d%3A0x754f30c82bcad3cd!2sJalkuri%20Bus%20Stop!5e0!3m2!1sen!2sbd!4v1605354966349!5m2!1sen!2sbd"></iframe>
                    </div>
                </div>
                <div class="col-lg-6">
                    @if ($errors->any())
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-danger inverse alert-dismissible fade show" role="alert"><i class="icon-thumb-down"></i>

                                <p>{{ $error }}</p>
                                <button class="close" type="button" data-dismiss="alert" aria-label="Close" data-original-title="" title=""><span aria-hidden="true">×</span></button>

                            </div>

                        @endforeach
                    @endif

                    <form class="contact-form" action="{{route('website.contact-us-submit')}}" method="POST">
                        @csrf
                        <input type="hidden" name="type" value="0">

                        <div class="col-lg-12">
                            <h3>{{__('website.contact')}} <span class="secondary-color bolder"> {{__('website.moon')}}</span> {{__('website.support')}} !</h3>
                            <p class="mb-3">

                                {{__('website.send-moon-message')}}
                            </p>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="form-group"><input type="text" name="name" class="form-control" placeholder="{{__('website.your-name')}}">
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group"><input type="email" name="email" class="form-control"
                                                               placeholder="{{__('website.your-email')}}"></div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group">
                                    <select name="reason_id" class="form-control">

                                        <option label="{{__('website.select-reason')}}"></option>

                                        @if(count($reasons))
                                            @foreach($reasons as $reason)
                                                <option value="{{$reason->id}}">{{$reason->content}}</option>
                                            @endforeach
                                        @endif
                                    </select>

                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group"><textarea class="form-control" name="message"
                                                                  placeholder="{{__('website.your-message')}}"></textarea></div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-btn"><button class="btn btn-inline"><i
                                            class="fas fa-paper-plane"></i><span>{{__('website.send-message')}}</span></button>
                                </div>
                            </div>
                            <div class="col-lg-12">

                            </div>

                            </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

@endsection
