@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/about.css')}}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/boxicons@latest/css/boxicons.min.css">

    <link rel="stylesheet" href="{{asset('website/css/custom/style-acourdion.css')}}">

@endsection
@section('page-title')
    {{__('website.help')}}
@endsection

@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.help')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.help')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('content')

    <section class="about-part mb-50">
        <div class="container">

            <div class="row">

                <div class="col-lg-12">
                    <div class="about-content">
                        <h2><span class="secondary-color bolder">{{__('website.moon')}}</span> {{__('website.faq')}}
                        </h2>
                    </div>
                    @if(count($questions)>0)
                        @foreach($questions as $question)
                            <div class="accordion__container">
                                <div class="accordion__item">
                                    <header class="accordion__header">
                                        <i class='bx bx-plus accordion__icon'></i>
                                        <h3 class="accordion__title">{{$question->title}}</h3>
                                    </header>

                                    <div class="accordion__content">
                                        <p class="accordion__description">
                                            {{$question->content}}                                        </p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif


                </div>

            </div>
        </div>
    </section>
@endsection
@section('extra-js-files')
    <script src="{{asset('website/js/custom/script-acourdion.js')}}"></script>

@endsection
